/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.jac.servicegui.data;

import ch.bruker.jac.servicegui.NamedThreadFactory;
import ch.bruker.jac.servicegui.data.CacheKey;
import ch.bruker.jac.servicegui.data.CacheTaskProducer;
import ch.bruker.jac.servicegui.data.cache.Container;
import com.google.common.cache.LoadingCache;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class CacheTaskConsumer
implements Runnable {
    private static final int CACHING_THREADS = Math.min(6, Runtime.getRuntime().availableProcessors());
    private final Iterator<CacheTaskProducer.Task> queue;
    private final LoadingCache<CacheKey, Container> cache;
    private final ThreadGroup workerGroup;
    final ExecutorService workers;

    CacheTaskConsumer(LoadingCache<CacheKey, Container> cache, Iterator<CacheTaskProducer.Task> queue) {
        this.queue = queue;
        this.cache = cache;
        NamedThreadFactory factory = new NamedThreadFactory("Cache Worker", 1);
        this.workerGroup = factory.group;
        this.workers = Executors.newFixedThreadPool(CACHING_THREADS, factory);
    }

    @Override
    public void run() {
        if (this.workerGroup.activeGroupCount() < CACHING_THREADS && this.queue.hasNext()) {
            this.workers.submit(new Runnable(){

                @Override
                public void run() {
                    CacheTaskProducer.Task task;
                    if (!CacheTaskConsumer.this.queue.hasNext()) {
                        return;
                    }
                    while (!Thread.currentThread().isInterrupted() && (task = (CacheTaskProducer.Task)CacheTaskConsumer.this.queue.next()) != null) {
                        try {
                            Set<CacheKey> keys = task.getKeys();
                            if (keys.size() > 12) {
                                CacheTaskConsumer.this.cache.get(keys.iterator().next());
                            }
                            CacheTaskConsumer.this.cache.getAll(keys);
                        }
                        catch (ExecutionException e) {
                            task.tock();
                            continue;
                        }
                        catch (RuntimeException e) {
                            task.tock();
                            continue;
                        }
                        task.tick();
                    }
                }
            });
        }
    }
}

