/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.jac.servicegui.data;

import ch.bruker.jac.servicegui.SGUtils;
import ch.bruker.jac.servicegui.collections.Pool;
import ch.bruker.jac.servicegui.data.Demuxer;
import ch.bruker.jac.servicegui.data.Header;
import ch.bruker.jac.servicegui.data.HeaderParser;
import ch.bruker.jac.servicegui.data.HwClock;
import ch.bruker.jac.servicegui.data.Log;
import ch.bruker.jac.servicegui.data.io.Source;
import com.google.common.collect.Range;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ArchiveLog
extends Log {
    private static final long serialVersionUID = 1L;
    public static final Pattern DATA_ARCHIVE = Pattern.compile("(\\d{10})_(\\d{10}).zip");
    private static final String HEADER_FILE = "Header.xml";
    private static final String DATA_FILE = "Data.bin";
    public final String filename;

    ArchiveLog(String filename) {
        this.filename = filename;
        Matcher matcher = DATA_ARCHIVE.matcher(filename);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid filename: " + filename);
        }
        this.span = Range.closed(new HwClock(matcher.group(1)), new HwClock(matcher.group(2)));
    }

    @Override
    public Header getHeader(Source source, Pool pool) {
        if (this.header == null) {
            try {
                this.header = HeaderParser.parse(pool, source.archives.openZip(this.filename, HEADER_FILE));
            }
            catch (Exception e) {
                SGUtils.err("Could not parse header in %s", this.filename);
                source.archives.invalidate(this.filename);
            }
        }
        return this.header;
    }

    @Override
    Demuxer getDemuxer(Source source, Pool pool) throws IOException {
        return new Demuxer(this.getHeader(source, pool), source.archives.openZip(this.filename, DATA_FILE));
    }

    @Override
    public void reset(Source source, Pool pool) {
        source.archives.invalidate(this.filename);
    }

    @Override
    void release(Source source) {
    }
}

