/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.jac.servicegui.collections;

import ch.bruker.jac.servicegui.SGUtils;
import ch.bruker.jac.servicegui.collections.Pool;
import com.google.common.base.Objects;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class PoolingHashMap<K, V>
implements Map<K, V>,
Serializable {
    private static final long serialVersionUID = 3L;
    public final Pool<V> pool;
    final ConcurrentHashMap<K, Integer> instance;
    final ConcurrentHashMap<K, V> collisions;

    public PoolingHashMap(Pool<V> pool) {
        this.pool = pool;
        this.instance = new ConcurrentHashMap();
        this.collisions = new ConcurrentHashMap();
    }

    public void printStats() {
        float weight = 0.0f;
        for (int hash : this.instance.values()) {
            int multiplicity = this.pool.refCount.get(hash).get();
            weight += 1.0f / (float)multiplicity;
        }
        SGUtils.log("Map weight ratio: %.1f%% . %d collisions with pool in %d entries.%n", Float.valueOf((weight += (float)this.collisions.size()) / (float)this.size()), this.collisions.size(), this.size());
    }

    @Override
    public int size() {
        return this.instance.size() + this.collisions.size();
    }

    @Override
    public boolean isEmpty() {
        return this.instance.isEmpty() && this.collisions.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.instance.containsKey(key) || this.collisions.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V get(Object key) {
        if (!this.collisions.isEmpty() && this.collisions.containsKey(key)) {
            return this.collisions.get(key);
        }
        Integer hash = this.instance.get(key);
        if (hash == null) {
            return null;
        }
        return this.pool.store.get(hash);
    }

    @Override
    public V put(K key, V value) {
        if (value == null) {
            this.instance.put(key, null);
            return null;
        }
        int hash = value.hashCode();
        Object inPool = this.pool.store.get(hash);
        if (inPool == null) {
            this.pool.store.put(hash, value);
            this.pool.refCount.put(hash, new AtomicInteger(1));
        } else {
            if (!value.equals(inPool)) {
                this.collisions.put(key, value);
            }
            this.pool.refCount.get(hash).incrementAndGet();
        }
        Integer inInstance = this.instance.put(key, hash);
        if (inInstance == null) {
            return null;
        }
        return this.pool.store.get(inInstance);
    }

    @Override
    public V remove(Object key) {
        if (this.collisions.containsKey(key)) {
            return this.collisions.remove(key);
        }
        Integer hash = this.instance.remove(key);
        if (hash == null) {
            return null;
        }
        Object value = this.pool.store.get(hash);
        int remainingRefs = this.pool.refCount.get(hash).decrementAndGet();
        if (remainingRefs == 0) {
            this.pool.store.remove(hash);
            this.pool.refCount.remove(hash);
        }
        return value;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        for (int hash : this.instance.values()) {
            int remainingRefs;
            try {
                remainingRefs = this.pool.refCount.get(hash).decrementAndGet();
            }
            catch (NullPointerException e) {
                remainingRefs = 0;
            }
            if (remainingRefs != 0) continue;
            this.pool.store.remove(hash);
            this.pool.refCount.remove(hash);
        }
        this.instance.clear();
        this.collisions.clear();
    }

    @Override
    public Set<K> keySet() {
        return Sets.union(this.instance.keySet(), this.collisions.keySet());
    }

    @Override
    public Collection<V> values() {
        LinkedList<V> values = new LinkedList<V>();
        for (int hash : this.instance.values()) {
            values.add(this.pool.store.get(hash));
        }
        values.addAll(this.collisions.values());
        return values;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        HashMap<K, V> entries = new HashMap<K, V>();
        for (Map.Entry<K, Integer> entry : this.instance.entrySet()) {
            Integer hash = entry.getValue();
            if (hash == null) {
                entries.put(entry.getKey(), null);
                continue;
            }
            entries.put(entry.getKey(), this.pool.store.get(hash));
        }
        entries.putAll(this.collisions);
        return entries.entrySet();
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.instance, this.collisions);
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof PoolingHashMap && this.instance.equals(((PoolingHashMap)obj).instance) && this.collisions.equals(((PoolingHashMap)obj).collisions);
    }
}

