/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.jac.servicegui.api;

import ch.bruker.jac.server.soap.JacSoapControl;
import ch.bruker.jac.servicegui.api.JacControl;
import ch.bruker.jac.servicegui.api.JacControlConnection;
import ch.bruker.jac.servicegui.api.JacControlSoapDelegate;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Service;

public class JacSoapControlConnection
implements JacControlConnection {
    private final String address;
    private final int port;
    private final String webProxyPath;
    private final Logger logger;
    private JacSoapControl jacControl;
    private JacControl jacControlSoapDelegate;
    private static final int CONNECT_TIMEOUT_MS = 20000;
    private static final int RECEIVE_TIMEOUT_MS = 20000;

    public JacSoapControlConnection(String address, int serverPort, String webProxyPath) {
        this.address = address;
        this.port = serverPort;
        this.webProxyPath = webProxyPath;
        this.logger = Logger.getLogger("javax.enterprise.resource.webservices.jaxws.server");
        this.logger.setLevel(Level.WARNING);
    }

    @Override
    public JacControl connect() throws MalformedURLException {
        URL url = new URL("http://" + this.address + ":" + this.port + this.webProxyPath + "/ws/JacSoapControl?wsdl");
        System.setProperty("javax.xml.soap.SAAJMetaFactory", "com.sun.xml.messaging.saaj.soap.SAAJMetaFactoryImpl");
        this.jacControlSoapDelegate = null;
        try {
            QName qname = new QName("http://soap.server.jac.bruker.ch/", "JacSoapControlImplService");
            Service service = Service.create((URL)url, (QName)qname);
            this.jacControl = (JacSoapControl)service.getPort(JacSoapControl.class);
            Map requestContext = ((BindingProvider)this.jacControl).getRequestContext();
            if (!this.webProxyPath.isEmpty()) {
                requestContext.put("javax.xml.ws.service.endpoint.address", "http://" + this.address + ":" + this.port + this.webProxyPath + "/ws/JacSoapControl");
            }
            requestContext.put("com.sun.xml.internal.ws.connect.timeout", 20000);
            requestContext.put("com.sun.xml.internal.ws.request.timeout", 20000);
            requestContext.put("com.sun.xml.ws.connect.timeout", 20000);
            requestContext.put("com.sun.xml.ws.request.timeout", 20000);
            requestContext.put("javax.xml.ws.client.connectionTimeout", 20000);
            requestContext.put("javax.xml.ws.client.receiveTimeout", 20000);
            this.jacControlSoapDelegate = new JacControlSoapDelegate(this.jacControl);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        return this.jacControlSoapDelegate;
    }

    @Override
    public void disconnect() {
    }

    @Override
    public void release() {
    }

    @Override
    public JacControl getJacControl() {
        return this.jacControlSoapDelegate;
    }
}

