/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.jac.servicegui.api;

import ch.bruker.jac.server.soap.JacSoapCommon;
import ch.bruker.jac.server.soap.JacSoapControl;
import ch.bruker.jac.servicegui.api.JacCommon;
import ch.bruker.jac.servicegui.api.JacControl;

public class JacControlSoapDelegate
extends JacControl {
    private JacSoapControl delegate;

    public JacControlSoapDelegate(JacSoapControl delegate) {
        this.delegate = delegate;
    }

    private static JacControl.JacPropertyExt[] convertToJacPropertyExts(JacSoapControl.JacPropertyExt[] jacPropertyExts) {
        JacControl.JacPropertyExt[] array = new JacControl.JacPropertyExt[jacPropertyExts.length];
        for (int i = 0; i < jacPropertyExts.length; ++i) {
            array[i] = JacControlSoapDelegate.convertToJacPropertyExt(jacPropertyExts[i]);
        }
        return array;
    }

    private static JacControl.JacPropertyExt convertToJacPropertyExt(JacSoapControl.JacPropertyExt jacPropertyExt) {
        JacCommon.JacValueType defaultValueType;
        if (jacPropertyExt.defaultValue != null) {
            defaultValueType = JacControlSoapDelegate.convertToJacValueType(jacPropertyExt.defaultValue);
        } else {
            defaultValueType = new JacCommon.JacValueType();
            defaultValueType.EmptyValue(true);
        }
        return new JacControl.JacPropertyExt(jacPropertyExt.parId, jacPropertyExt.parName, jacPropertyExt.unit, JacControlSoapDelegate.convertToJacValueType(jacPropertyExt.value), JacControlSoapDelegate.convertToJacValueType(jacPropertyExt.min), JacControlSoapDelegate.convertToJacValueType(jacPropertyExt.max), JacControlSoapDelegate.convertToJacPropertyEntryNames(jacPropertyExt.allowedValues), JacControlSoapDelegate.convertToJacValueType(jacPropertyExt.stepSize), jacPropertyExt.accessLevel, jacPropertyExt.format, defaultValueType);
    }

    private static JacControl.JacPropertyEntryName[] convertToJacPropertyEntryNames(JacSoapControl.JacPropertyEntryName[] jacPropertyEntryNames) {
        JacControl.JacPropertyEntryName[] array = new JacControl.JacPropertyEntryName[jacPropertyEntryNames.length];
        for (int i = 0; i < jacPropertyEntryNames.length; ++i) {
            array[i] = JacControlSoapDelegate.convertToJacPropertyEntryName(jacPropertyEntryNames[i]);
        }
        return array;
    }

    private static JacControl.JacPropertyEntryName convertToJacPropertyEntryName(JacSoapControl.JacPropertyEntryName jacPropertyEntryName) {
        return new JacControl.JacPropertyEntryName(JacControlSoapDelegate.convertToJacValueType(jacPropertyEntryName.value), jacPropertyEntryName.name);
    }

    private static JacSoapCommon.JacValueType convertFromJacValueType(JacCommon.JacValueType value) {
        JacSoapCommon.JacValueType jacValueType = new JacSoapCommon.JacValueType();
        switch (value.discriminator()) {
            case ValueBoolean: {
                jacValueType.BooleanVal(value.BooleanVal());
                break;
            }
            case ValueByteArray: {
                jacValueType.ByteArrayVal(value.ByteArrayVal());
                break;
            }
            case ValueDouble: {
                jacValueType.DoubleVal(value.DoubleVal());
                break;
            }
            case ValueEmpty: {
                jacValueType.EmptyValue(value.EmptyValue());
                break;
            }
            case ValueFloat: {
                jacValueType.FloatVal(value.FloatVal());
                break;
            }
            case ValueInt32: {
                jacValueType.Int32Val(value.Int32Val());
                break;
            }
            case ValueString: {
                jacValueType.StringVal(value.StringVal());
            }
        }
        return jacValueType;
    }

    private static JacCommon.JacValueType convertToJacValueType(JacSoapCommon.JacValueType value) {
        JacCommon.JacValueType jacValueType = new JacCommon.JacValueType();
        switch (value.discriminator()) {
            case BOOLEAN: {
                jacValueType.BooleanVal(value.BooleanVal());
                break;
            }
            case BYTE_ARRAY: {
                jacValueType.ByteArrayVal(value.ByteArrayVal());
                break;
            }
            case DOUBLE: {
                jacValueType.DoubleVal(value.DoubleVal());
                break;
            }
            case EMPTY: {
                jacValueType.EmptyValue(value.EmptyValue());
                break;
            }
            case FLOAT: {
                jacValueType.FloatVal(value.FloatVal());
                break;
            }
            case INT32: {
                jacValueType.Int32Val(value.Int32Val());
                break;
            }
            case STRING: {
                jacValueType.StringVal(value.StringVal());
            }
        }
        return jacValueType;
    }

    private static JacSoapCommon.JacProperty[] convertFromJacProperties(JacCommon.JacProperty[] jacProperties) {
        JacSoapCommon.JacProperty[] array = new JacSoapCommon.JacProperty[jacProperties.length];
        for (int i = 0; i < jacProperties.length; ++i) {
            array[i] = JacControlSoapDelegate.convertFromJacProperty(jacProperties[i]);
        }
        return array;
    }

    private static JacSoapCommon.JacProperty convertFromJacProperty(JacCommon.JacProperty jacProperty) {
        return new JacSoapCommon.JacProperty(jacProperty.parId, JacControlSoapDelegate.convertFromJacValueType(jacProperty.value));
    }

    private static JacControl.JacParamNotAvailable convertToJacParamNotAvailable(JacSoapControl.JacParamNotAvailable e) {
        JacSoapControl.JacParamNotAvailableFaultInfo faultInfo = e.getFaultInfo();
        return new JacControl.JacParamNotAvailable(faultInfo.parId, faultInfo.statement);
    }

    private static JacCommon.JacIoError convertToJacIoError(JacSoapCommon.JacIoError e) {
        JacSoapCommon.JacIoErrorFaultInfo faultInfo = e.getFaultInfo();
        return new JacCommon.JacIoError(faultInfo.statementId, faultInfo.statement);
    }

    @Override
    protected JacControl.JacPropertyExt[] getParametersFromJac(String[] parameters) throws JacControl.JacParamNotAvailable {
        try {
            return JacControlSoapDelegate.convertToJacPropertyExts(this.delegate.getParameters(parameters));
        }
        catch (JacSoapControl.JacParamNotAvailable e) {
            throw JacControlSoapDelegate.convertToJacParamNotAvailable(e);
        }
        catch (RuntimeException e) {
            throw new JacControl.JacParamNotAvailable("undefined_parameter", e.getMessage());
        }
    }

    @Override
    public void pushParametersToJac(int jacKey, JacCommon.JacProperty[] parameters) throws JacControl.JacParamNotAvailable {
        try {
            this.delegate.pushParameters(jacKey, JacControlSoapDelegate.convertFromJacProperties(parameters));
        }
        catch (JacSoapControl.JacParamNotAvailable e) {
            throw JacControlSoapDelegate.convertToJacParamNotAvailable(e);
        }
        catch (RuntimeException e) {
            throw new JacControl.JacParamNotAvailable("undefined_parameter", e.getMessage());
        }
    }

    @Override
    public int getChallengeNumber() {
        return this.delegate.getChallengeNumber();
    }

    @Override
    public int login(String user, String password, int userlevel) throws JacCommon.JacIoError {
        try {
            return this.delegate.login(user, password, userlevel);
        }
        catch (JacSoapCommon.JacIoError e) {
            throw JacControlSoapDelegate.convertToJacIoError(e);
        }
        catch (RuntimeException e) {
            throw new JacCommon.JacIoError(0, e.getMessage());
        }
    }

    @Override
    public void logout(int jacKey, String user) throws JacCommon.JacIoError {
        try {
            this.delegate.logout(jacKey, user);
        }
        catch (JacSoapCommon.JacIoError e) {
            throw JacControlSoapDelegate.convertToJacIoError(e);
        }
        catch (RuntimeException e) {
            throw new JacCommon.JacIoError(0, e.getMessage());
        }
    }
}

