/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.jac.servicegui.api;

import ch.bruker.jac.servicegui.api.JacCommon;
import java.util.LinkedList;

public abstract class JacControl {
    protected abstract JacPropertyExt[] getParametersFromJac(String[] var1) throws JacParamNotAvailable;

    public JacPropertyExt getParameter(String parameter) throws JacParamNotAvailable {
        return this.getParametersFromJac(new String[]{parameter})[0];
    }

    public JacPropertyExt[] getParameters(String[] parameters) throws JacParamNotAvailable {
        int len = parameters.length;
        LinkedList<String> validPars = new LinkedList<String>();
        for (String par : parameters) {
            if (par == null) continue;
            validPars.add(par);
        }
        JacPropertyExt[] response = this.getParametersFromJac(validPars.toArray(new String[0]));
        JacPropertyExt[] ret = new JacPropertyExt[len];
        for (int retIdx = 0; retIdx < len; ++retIdx) {
            String par;
            par = parameters[retIdx];
            int responseIdx = validPars.indexOf(par);
            if (responseIdx < 0) continue;
            ret[retIdx] = response[responseIdx];
        }
        return ret;
    }

    protected abstract void pushParametersToJac(int var1, JacCommon.JacProperty[] var2) throws JacParamNotAvailable;

    public void pushParameters(int jacKey, JacCommon.JacProperty[] pars) throws JacParamNotAvailable {
        this.pushParametersToJac(jacKey, pars);
    }

    public abstract int getChallengeNumber();

    public abstract int login(String var1, String var2, int var3) throws JacCommon.JacIoError;

    public abstract void logout(int var1, String var2) throws JacCommon.JacIoError;

    public static class JacPropertyExt {
        public String parId;
        public String parName;
        public String unit;
        public JacCommon.JacValueType value;
        public JacCommon.JacValueType min;
        public JacCommon.JacValueType max;
        public JacPropertyEntryName[] allowedValues;
        public JacCommon.JacValueType stepSize;
        public int accessLevel;
        public String format;
        public JacCommon.JacValueType defaultValue;

        public JacPropertyExt() {
        }

        public JacPropertyExt(String parId, String parName, String unit, JacCommon.JacValueType value, JacCommon.JacValueType min, JacCommon.JacValueType max, JacPropertyEntryName[] allowedValues, JacCommon.JacValueType stepSize, int accessLevel, String format, JacCommon.JacValueType defaultValue) {
            this.parId = parId;
            this.parName = parName;
            this.unit = unit;
            this.value = value;
            this.min = min;
            this.max = max;
            this.allowedValues = allowedValues;
            this.stepSize = stepSize;
            this.accessLevel = accessLevel;
            this.format = format;
            this.defaultValue = defaultValue;
        }
    }

    public static class JacPropertyEntryName {
        public JacCommon.JacValueType value;
        public String name;

        public JacPropertyEntryName(JacCommon.JacValueType value, String name) {
            this.value = value;
            this.name = name;
        }
    }

    public static class JacParamBlacklisted
    extends JacParamNotAvailable {
        public JacParamBlacklisted(String parId) {
            super(parId, "Parameter was detected to be missing earlier");
        }
    }

    public static class JacParamNotAvailable
    extends Exception {
        public String parId;
        public String statement;

        public JacParamNotAvailable(String parId, String statement) {
            this.parId = parId;
            this.statement = statement;
        }
    }
}

