/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.jac.servicegui.api;

import ch.bruker.jac.config.JacPublicDefinitions;
import ch.bruker.jac.servicegui.NamedThreadFactory;
import ch.bruker.jac.servicegui.SGUtils;
import ch.bruker.jac.servicegui.api.JacCommon;
import ch.bruker.jac.servicegui.api.JacControl;
import ch.bruker.jac.servicegui.api.JacControlConnection;
import ch.bruker.jac.servicegui.api.JacSoapControlConnection;
import ch.bruker.jac.servicegui.data.HwClock;
import ch.bruker.jac.servicegui.status.ui.LoadingCompleteCallback;
import ch.bruker.util.Bis;
import com.google.common.base.Optional;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class ApiTalker {
    private static final DateTimeFormatter apiFormatter = DateTimeFormat.forPattern("yyyy/MM/dd HH:mm:ss.SSS").withLocale(Locale.US);
    private static final String CORBA_SERVER_NAME = "JacController";
    private static final int CORBA_SERVER_PORT = 5500;
    private final String host;
    private final int port;
    private final String webProxyPath;
    private String username = "";
    private int key;
    private Protocol preferred;
    private JacControl connection;
    private JacControlConnection connector;
    private LoadingCache<String, Optional<JacControl.JacPropertyExt>> cache;
    public final Multimap<String, LoadingCompleteCallback> pendingCallbacks;
    private Set<String> blacklist = Collections.newSetFromMap(new ConcurrentHashMap());
    private volatile Future<?> busy;
    private Runnable idleCallback;
    private Runnable busyCallback = this.idleCallback = new Runnable(){

        @Override
        public void run() {
        }
    };
    private Runnable connectionBrokenCallback = this.idleCallback;
    private Semaphore fetchSignal = new Semaphore(0);
    private ExecutorService loader = Executors.newSingleThreadExecutor(new NamedThreadFactory("API"));

    public JacControl getConnection() {
        return this.connection;
    }

    public void resetBlacklist() {
        this.blacklist.clear();
        this.cache.invalidateAll();
    }

    public synchronized void awaitNextFetch() throws InterruptedException {
        if (this.pendingCallbacks.isEmpty()) {
            Thread.sleep(100L);
            return;
        }
        this.fetchSignal.drainPermits();
        this.startWorking();
        this.fetchSignal.tryAcquire(1L, TimeUnit.SECONDS);
    }

    public ApiTalker(String host, int port, String webProxyPath) throws RemoteException {
        this.host = host;
        this.port = port;
        this.webProxyPath = webProxyPath;
        this.preferred = Protocol.SOAP;
        this.requireConnection();
        this.pendingCallbacks = Multimaps.synchronizedSetMultimap(HashMultimap.create());
        this.cache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.SECONDS).build(new CacheLoader<String, Optional<JacControl.JacPropertyExt>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Map<String, Optional<JacControl.JacPropertyExt>> loadAll(Iterable<? extends String> requested) throws Exception {
                HashMap<String, Optional<JacControl.JacPropertyExt>> ret = new HashMap<String, Optional<JacControl.JacPropertyExt>>();
                for (String string : requested) {
                    ret.put(string, Optional.absent());
                }
                int n = 0;
                while (true) {
                    HashSet<String> hashSet;
                    Multimap<String, LoadingCompleteCallback> multimap = ApiTalker.this.pendingCallbacks;
                    synchronized (multimap) {
                        hashSet = new HashSet<String>(ApiTalker.this.pendingCallbacks.keys());
                    }
                    hashSet.addAll(Sets.newHashSet(requested));
                    hashSet.removeAll(ApiTalker.this.blacklist);
                    try {
                        JacControl.JacPropertyExt[] props;
                        for (JacControl.JacPropertyExt prop : props = ApiTalker.this.connection.getParametersFromJac(hashSet.toArray(new String[0]))) {
                            ret.put(prop.parId, Optional.of(prop));
                        }
                        return ret;
                    }
                    catch (JacControl.JacParamNotAvailable na) {
                        if (na.parId.equals("undefined_parameter")) {
                            throw new IOException();
                        }
                        SGUtils.log("Error %d: Parameter %s could not be fetched: %s. Adding to blacklist.", ++n, na.parId, na.statement);
                        ApiTalker.this.blacklist.add(na.parId);
                        continue;
                    }
                    break;
                }
            }

            @Override
            public Optional<JacControl.JacPropertyExt> load(String parId) throws Exception {
                return this.loadAll((Iterable<? extends String>)Collections.singleton(parId)).get(parId);
            }
        });
    }

    public Bis getBis() throws RemoteException {
        try {
            String bisParam = this.connection.getParameter((String)"APPLICATION_BIS").value.StringVal();
            return new Bis(bisParam.getBytes());
        }
        catch (JacControl.JacParamNotAvailable e) {
            throw new RemoteException(e);
        }
    }

    public void schedule(String parId, LoadingCompleteCallback callback) {
        if (parId == null) {
            throw new NullPointerException("Invalid parId.");
        }
        this.pendingCallbacks.put(parId, callback);
        this.startWorking();
    }

    private void startWorking() {
        if (this.busy != null && !this.busy.isDone()) {
            return;
        }
        this.busy = this.loader.submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (ApiTalker.this.pendingCallbacks.isEmpty()) {
                    return;
                }
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            ApiTalker.this.busyCallback.run();
                        }
                    });
                }
                catch (InterruptedException ignore) {
                }
                catch (InvocationTargetException ignore) {
                    // empty catch block
                }
                while (!ApiTalker.this.pendingCallbacks.isEmpty()) {
                    try {
                        ImmutableMap all = ApiTalker.this.cache.getAll(ApiTalker.this.pendingCallbacks.keySet());
                        for (Map.Entry entry : all.entrySet()) {
                            Collection<LoadingCompleteCallback> callbacks;
                            final Optional prop = (Optional)entry.getValue();
                            Multimap<String, LoadingCompleteCallback> multimap = ApiTalker.this.pendingCallbacks;
                            synchronized (multimap) {
                                callbacks = ApiTalker.this.pendingCallbacks.removeAll(entry.getKey());
                            }
                            if (callbacks.isEmpty()) continue;
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    for (LoadingCompleteCallback callback : callbacks) {
                                        callback.with((JacControl.JacPropertyExt)prop.orNull());
                                    }
                                }
                            });
                        }
                    }
                    catch (ExecutionException e) {
                        e.printStackTrace();
                        ApiTalker.this.connectionBrokenCallback.run();
                    }
                }
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            ApiTalker.this.idleCallback.run();
                        }
                    });
                }
                catch (InterruptedException ignore) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
                ApiTalker.this.fetchSignal.release(1);
            }
        });
    }

    public void bindBusy(Runnable runnable) {
        this.busyCallback = runnable;
    }

    public void bindIdle(Runnable runnable) {
        this.idleCallback = runnable;
    }

    public void bindConnectionBroken(Runnable runnable) {
        this.connectionBrokenCallback = runnable;
    }

    public void connect() throws RemoteException {
        try {
            this.connector = this.preferred.connect(this.host, this.port, this.webProxyPath);
            this.connection = this.connector.connect();
        }
        catch (Exception e) {
            SGUtils.log("Could not connect using %s (%s).", new Object[]{this.preferred, e.getMessage()});
            throw new RemoteException(e);
        }
    }

    public void disconnect() throws RemoteException {
        if (!this.username.isEmpty()) {
            this.logout();
        }
        this.connector.disconnect();
        this.connection = null;
    }

    public boolean login(String userName, String password, JacPublicDefinitions.UserLevel userLevel) throws RemoteException {
        this.requireConnection();
        try {
            this.key = this.connection.login(userName, password, userLevel.value);
            this.username = userName;
        }
        catch (JacCommon.JacIoError e) {
            if (e.getMessage().contains("Password")) {
                return false;
            }
            if (e.getMessage().contains("Unknown user")) {
                return false;
            }
            this.connection = null;
            throw new RemoteException(e);
        }
        catch (Exception e) {
            this.connection = null;
            throw new RemoteException(e);
        }
        return true;
    }

    public void requireConnection() throws RemoteException {
        if (this.connection == null) {
            this.connect();
        }
    }

    public void logout() throws RemoteException {
        try {
            this.requireConnection();
            this.connection.logout(this.key, this.username);
        }
        catch (JacCommon.JacIoError jacIoError) {
            this.connection = null;
            throw new RemoteException(jacIoError);
        }
        this.username = "";
        this.key = 0;
    }

    public int getChallengeNumber() throws RemoteException {
        this.requireConnection();
        return this.connection.getChallengeNumber();
    }

    public int getKey() {
        return this.key;
    }

    public void sendHighResLoggingSignal() throws RemoteException {
        this.requireConnection();
        JacCommon.JacValueType type = new JacCommon.JacValueType();
        type.BooleanVal(true);
        JacCommon.JacProperty prop = new JacCommon.JacProperty("JAC_HIGH_RES_LOGGING", type);
        try {
            this.connection.pushParameters(0, new JacCommon.JacProperty[]{prop});
        }
        catch (JacControl.JacParamNotAvailable jacParamNotAvailable) {
            // empty catch block
        }
    }

    public void sendGmtTimestamp() throws RemoteException {
        this.requireConnection();
        JacCommon.JacValueType currentGmt = new JacCommon.JacValueType();
        String string = apiFormatter.print(new DateTime(DateTimeZone.UTC));
        currentGmt.StringVal(string);
        JacCommon.JacValueType currentTimeZone = new JacCommon.JacValueType();
        currentTimeZone.StringVal(TimeZone.getDefault().getID());
        try {
            this.connection.pushParameters(0, new JacCommon.JacProperty[]{new JacCommon.JacProperty("TIME_ZONE", currentTimeZone), new JacCommon.JacProperty("REAL_TIME_GMT", currentGmt)});
            SGUtils.log("Time server: GMT timestamp sent to JAC: %s", string);
        }
        catch (JacControl.JacParamNotAvailable jacParamNotAvailable) {
            SGUtils.log("Time server: Could not push current time (%s)!", string);
        }
    }

    public DateTime getJacTime() throws RemoteException {
        this.requireConnection();
        try {
            JacControl.JacPropertyExt[] pars = this.connection.getParameters(new String[]{"TIME_ZONE", "REAL_TIME_GMT"});
            String tz = pars[0].value.StringVal();
            String string = pars[1].value.StringVal();
        }
        catch (JacControl.JacParamNotAvailable jacParamNotAvailable) {
            // empty catch block
        }
        return null;
    }

    public HwClock getJacHwClock() throws RemoteException {
        this.requireConnection();
        try {
            return new HwClock(this.connection.getParameter((String)"HARDWARE_TIME").value.Int32Val());
        }
        catch (JacControl.JacParamNotAvailable e) {
            throw new RemoteException(e);
        }
    }

    public void ping() throws RemoteException {
        try {
            try {
                this.connection.getParameter("JAC_CPU_TEMP");
            }
            catch (JacControl.JacParamNotAvailable jacParamNotAvailable) {
                this.connection = null;
                throw new RemoteException(jacParamNotAvailable);
            }
        }
        catch (RuntimeException e) {
            this.connection = null;
            throw new RemoteException(e);
        }
    }

    public static enum Protocol {
        SOAP{

            @Override
            public JacControlConnection connect(String host, int port, String webProxyPath) {
                return new JacSoapControlConnection(host, port, webProxyPath);
            }
        }
        ,
        NONE{

            @Override
            JacControlConnection connect(String host, int port, String webProxyPath) {
                return null;
            }
        };


        abstract JacControlConnection connect(String var1, int var2, String var3);
    }

    public class RemoteException
    extends IOException {
        RemoteException(Exception cause) {
            super(cause);
        }
    }
}

