/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.jac.servicegui;

import ch.bruker.jac.servicegui.SGUtils;
import com.google.common.io.ByteStreams;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.TimeZone;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class TimeRefsPrinter {
    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            System.out.println("Please provide a time_refs.bin as a first argument.");
            return;
        }
        DataInputStream in = new DataInputStream(new FileInputStream(args[0]));
        int timestamp_ = 0;
        long millis_ = 0L;
        System.out.println("HW-Timestamp (hex/dec)   Row Type |  (Time zone / Event)                                               +TS   /      +UTC");
        while (true) {
            byte rowType;
            try {
                rowType = in.readByte();
            }
            catch (EOFException ignore) {
                break;
            }
            int timestamp = in.readInt();
            System.out.printf("0x%08X ", timestamp);
            System.out.printf("%12d   ", timestamp);
            int cursor = 5;
            switch (rowType) {
                case -16: {
                    ++cursor;
                    byte eventType = in.readByte();
                    System.out.printf("Event %d |  ", eventType);
                    switch (eventType) {
                        case 2: {
                            System.out.println("Startup.");
                            break;
                        }
                        case 1: {
                            System.out.println("Shutdown.");
                        }
                    }
                    break;
                }
                case -1: {
                    System.out.printf("Mapping |  ", new Object[0]);
                    long millis = in.readLong();
                    cursor += 8;
                    byte[] buffer = new byte[32];
                    in.readFully(buffer);
                    String id = new String(buffer, "UTF-8").replaceAll("\\s\\s+$", "").trim();
                    DateTimeZone timeZone = DateTimeZone.forTimeZone(TimeZone.getTimeZone(id));
                    System.out.printf("Zone: %-20s", id);
                    cursor += 32;
                    System.out.printf("UTC: %-22s", SGUtils.DATE_TIME_FORMATTER.print(new DateTime(millis, DateTimeZone.UTC)));
                    if (millis_ != 0L) {
                        System.out.printf("         %9d / %9d", timestamp - timestamp_, (millis - millis_) / 1000L);
                    }
                    System.out.println();
                    millis_ = millis;
                    timestamp_ = timestamp;
                }
            }
            ByteStreams.skipFully(in, 48 - cursor);
        }
    }
}

