/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.jac.servicegui;

import ch.bruker.jac.servicegui.Manifest;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.util.Date;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class Tab
extends JPanel
implements Printable {
    @Override
    public int print(Graphics g, PageFormat pageFormat, int pageIndex) throws PrinterException {
        int MIN_PAGE_BORDERS = 35;
        if (pageIndex > 0) {
            return 1;
        }
        Graphics2D g2d = (Graphics2D)g;
        double xTrans = pageFormat.getImageableX();
        double yTrans = pageFormat.getImageableY();
        double pageWidth = pageFormat.getImageableWidth();
        double pageHeight = pageFormat.getImageableHeight();
        if (xTrans < 35.0 && yTrans < 35.0) {
            pageWidth = pageWidth + 2.0 * xTrans - 70.0;
            pageHeight = pageHeight + 2.0 * yTrans - 70.0;
            xTrans = 35.0;
            yTrans = 35.0;
        }
        g2d.translate(xTrans, yTrans);
        double xScale = pageWidth / (double)this.getWidth();
        double yScale = pageHeight / (double)this.getHeight();
        double minScale = Math.min(xScale, yScale);
        Shape originalClip = g2d.getClip();
        AffineTransform originalTransform = g2d.getTransform();
        g2d.scale(minScale, minScale);
        this.printAll(g2d);
        g2d.setColor(Color.black);
        g2d.setStroke(new BasicStroke());
        g2d.drawRect(0, 0, this.getWidth(), this.getHeight());
        g2d.setTransform(originalTransform);
        g2d.setClip(originalClip);
        String printedBy = "Printed by JAC service tool " + Manifest.versionString();
        g2d.setFont(g2d.getFont().deriveFont(2, 8.0f));
        g2d.setColor(Color.gray);
        g2d.drawString(printedBy + "    " + new Date(), 0, (int)pageHeight);
        return 0;
    }

    public boolean isActive() {
        Container parent = this.getParent();
        return parent instanceof JPanel || ((JTabbedPane)parent).getSelectedComponent().equals(this);
    }

    public JTabbedPane getTabbedPane() {
        Container parent = this.getParent();
        if (parent instanceof JTabbedPane) {
            return (JTabbedPane)parent;
        }
        return null;
    }

    public int getTabbedPaneIdx() {
        JTabbedPane pane = this.getTabbedPane();
        if (pane == null) {
            return -1;
        }
        for (int i = 0; i < pane.getTabCount(); ++i) {
            if (pane.getComponentAt(i) != this) continue;
            return i;
        }
        return -1;
    }
}

