/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.jac.servicegui;

import ch.bruker.jac.servicegui.Trigger;
import ch.bruker.jac.servicegui.systems.Settings;
import ch.bruker.util.DirSelector;
import com.google.common.eventbus.EventBus;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;

class SettingsDialog
extends JDialog {
    SettingsDialog(JFrame parent, final Settings settings, final EventBus updates) {
        super(parent);
        this.setResizable(false);
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Preferences");
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 2;
        constraints.insets = new Insets(4, 10, 4, 10);
        constraints.anchor = 17;
        constraints.gridy = -1;
        Insets def = constraints.insets;
        constraints.insets = new Insets(20, def.left, def.bottom, def.right);
        constraints.gridx = 0;
        ++constraints.gridy;
        this.getContentPane().add((Component)new JLabel("Graph scaling method"), constraints);
        constraints.gridx = 1;
        final JComboBox scalingMethodCombo = this.comboBoxFor(settings.scaling);
        this.getContentPane().add((Component)scalingMethodCombo, constraints);
        constraints.insets = def;
        constraints.gridx = 0;
        ++constraints.gridy;
        this.getContentPane().add((Component)new JLabel("Time Zone"), constraints);
        constraints.gridx = 1;
        final JComboBox timeZoneCombo = this.comboBoxFor(settings.timeZoneSource);
        this.getContentPane().add((Component)timeZoneCombo, constraints);
        constraints.gridx = 0;
        ++constraints.gridy;
        this.getContentPane().add((Component)new JLabel("Show textlog in graph tab"), constraints);
        constraints.gridx = 1;
        final JCheckBox textlogBox = this.checkBoxFor(Settings.textLogInTimeLine);
        this.getContentPane().add((Component)textlogBox, constraints);
        constraints.gridx = 0;
        ++constraints.gridy;
        this.getContentPane().add((Component)new JLabel("Shade outliers"), constraints);
        constraints.gridx = 1;
        final JCheckBox peakDetBox = this.checkBoxFor(settings.shadeOutliers);
        this.getContentPane().add((Component)peakDetBox, constraints);
        constraints.gridx = 0;
        ++constraints.gridy;
        this.getContentPane().add((Component)new JLabel("Show axes"), constraints);
        constraints.gridx = 1;
        final JCheckBox axesBox = this.checkBoxFor(settings.showAxes);
        this.getContentPane().add((Component)axesBox, constraints);
        constraints.gridx = 0;
        ++constraints.gridy;
        this.getContentPane().add((Component)new JLabel("Round axis range"), constraints);
        constraints.gridx = 1;
        final JCheckBox roundAxesBox = this.checkBoxFor(settings.roundAxisRange);
        this.getContentPane().add((Component)roundAxesBox, constraints);
        constraints.gridx = 0;
        ++constraints.gridy;
        this.getContentPane().add((Component)new JLabel("Show grid"), constraints);
        constraints.gridx = 1;
        final JCheckBox gridBox = this.checkBoxFor(settings.showGrid);
        this.getContentPane().add((Component)gridBox, constraints);
        constraints.gridx = 0;
        ++constraints.gridy;
        this.getContentPane().add((Component)new JLabel("Working directory"), constraints);
        constraints.gridx = 1;
        final DirSelector workingDirSelector = this.dirSelectorFor(Settings.workingPath);
        this.getContentPane().add((Component)workingDirSelector, constraints);
        constraints.gridx = 0;
        ++constraints.gridy;
        this.getContentPane().add((Component)new JLabel("'Open file\u2026'-Location"), constraints);
        constraints.gridx = 1;
        final DirSelector openDirectorySelector = this.dirSelectorFor(Settings.openDialogPath);
        this.getContentPane().add((Component)openDirectorySelector, constraints);
        constraints.gridx = 0;
        ++constraints.gridy;
        this.getContentPane().add((Component)new JLabel("Reset user-defined graph colors"), constraints);
        constraints.gridx = 1;
        constraints.fill = 0;
        JButton resetUserGraphColorsButton = new JButton("Reset to defaults");
        resetUserGraphColorsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                settings.colors.set(new HashSet());
                updates.post(new Trigger("resetColors"));
            }
        });
        this.getContentPane().add((Component)resetUserGraphColorsButton, constraints);
        constraints.gridx = 0;
        ++constraints.gridy;
        constraints.gridx = 1;
        constraints.insets = new Insets(20, def.left, 20, def.right);
        JButton save = new JButton("Save");
        constraints.fill = 0;
        constraints.anchor = 13;
        this.getContentPane().add((Component)save, constraints);
        save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                settings.scaling.set((Settings.ScalingModes)scalingMethodCombo.getSelectedIndex());
                settings.timeZoneSource.set((Settings.Timezones)timeZoneCombo.getSelectedIndex());
                Settings.textLogInTimeLine.set(textlogBox.isSelected());
                settings.shadeOutliers.set(peakDetBox.isSelected());
                settings.showAxes.set(axesBox.isSelected());
                settings.roundAxisRange.set(roundAxesBox.isSelected());
                settings.showGrid.set(gridBox.isSelected());
                Settings.openDialogPath.set(openDirectorySelector.getPath());
                Settings.workingPath.set(workingDirSelector.getPath());
                updates.post(new Trigger("timeLineRepaint"));
                updates.post(new Trigger("panelRebuild"));
                SettingsDialog.this.dispose();
            }
        });
        this.pack();
        this.setLocationRelativeTo(parent);
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setVisible(true);
    }

    private JCheckBox checkBoxFor(Settings.Field field) {
        JCheckBox box = new JCheckBox();
        box.setSelected(field.getBoolean());
        return box;
    }

    private <E extends Enum<E>> JComboBox comboBoxFor(Settings.SpecificEnumField<E> field) {
        JComboBox box = new JComboBox(field.clazz.getEnumConstants());
        box.setSelectedItem(field.get());
        return box;
    }

    private DirSelector dirSelectorFor(Settings.Field field) {
        return new DirSelector(field.getString());
    }
}

