/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.jac.servicegui;

import ch.bruker.jac.servicegui.img.Images;
import java.awt.GridBagConstraints;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.util.IllegalFormatException;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.PeriodFormatter;
import org.joda.time.format.PeriodFormatterBuilder;

public class SGUtils {
    public static final String DATE_FORMAT_PATTERN = "MM/dd/yyyy";
    public static final DateTimeFormatter DATE_FORMATTER = DateTimeFormat.forPattern("MM/dd/yyyy");
    public static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormat.forPattern("MMM d yyyy HH:mm:ss");
    public static final PeriodFormatter PERIOD_FORMATTER = new PeriodFormatterBuilder().appendYears().appendSuffix("y ").appendMonths().appendSuffix("M ").appendDays().appendSuffix("d ").appendHours().appendSuffix("h ").appendMinutes().appendSuffix("m ").appendSeconds().appendSuffix("s").toFormatter();
    public static final List<? extends Image> PROGRAM_ICONS;

    public static Locale getLocale() {
        return Locale.ENGLISH;
    }

    public static GridBagConstraints createDefaultGridBagConstraints(int margin, int rightMargin) {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 2;
        constraints.insets = new Insets(margin, margin, margin, rightMargin);
        constraints.anchor = 17;
        return constraints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void store(Object object, File file) {
        int bufferSize = 524288;
        ObjectOutputStream oos = null;
        try {
            if (!file.exists()) {
                if (!file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                file.createNewFile();
            }
            oos = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file), 524288));
            oos.writeObject(object);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                oos.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object load(File file) {
        int bufferSize = 524288;
        Object retObj = null;
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(new BufferedInputStream(new FileInputStream(file), 524288));
            retObj = ois.readObject();
        }
        catch (IOException e) {
            SGUtils.log("Warning: Could not load object from file: %s", e.getMessage());
        }
        catch (ClassNotFoundException e) {
            SGUtils.log("Warning: Could not load object from file: %s", e.getMessage());
        }
        finally {
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (Exception ignore) {}
            }
        }
        return retObj;
    }

    private static void print(String format, PrintStream target, Object ... args) {
        int len;
        String thread = Thread.currentThread().getName();
        if (SwingUtilities.isEventDispatchThread()) {
            thread = "Swing EDT";
        }
        if ((len = thread.length()) > 10) {
            thread = "\u2026" + thread.substring(len - 9, len);
        }
        try {
            target.format("%n%20s | %10s | %s", DATE_TIME_FORMATTER.print(DateTime.now()), thread, String.format(format, args));
        }
        catch (IllegalFormatException e) {
            System.err.print("Illegal format string in #log statement:");
            e.printStackTrace();
        }
    }

    public static void err(String format, Object ... args) {
        SGUtils.print(format, System.err, args);
    }

    public static void log(String format, Object ... args) {
        SGUtils.print(format, System.out, args);
    }

    public static int sizeOf(Object obj) throws IOException {
        ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteOutputStream);
        objectOutputStream.writeObject(obj);
        objectOutputStream.flush();
        objectOutputStream.close();
        return byteOutputStream.toByteArray().length;
    }

    public static void eolNormalizingStreamCopy(InputStream in, OutputStream out) throws IOException {
        String buf;
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out));
        while ((buf = reader.readLine()) != null) {
            writer.write(buf);
            writer.newLine();
        }
        writer.flush();
        reader.close();
    }

    public static void focusLater(final JComponent component) {
        new Thread("focusLater timing workaround thread"){

            @Override
            public void run() {
                try {
                    1.sleep(200L);
                }
                catch (InterruptedException ie) {
                    1.currentThread().interrupt();
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        component.requestFocusInWindow();
                    }
                });
            }
        }.start();
    }

    public static boolean parseBoolean(String text) throws IllegalArgumentException {
        boolean isFalse;
        boolean isTrue = "true".equalsIgnoreCase(text) || "1".equals(text);
        boolean bl = isFalse = "false".equalsIgnoreCase(text) || "0".equals(text);
        if (isTrue == isFalse) {
            throw new IllegalArgumentException("Can not parse boolean from '" + text + "'");
        }
        return isTrue;
    }

    public static boolean isCapsLocked() {
        try {
            return Toolkit.getDefaultToolkit().getLockingKeyState(20);
        }
        catch (UnsupportedOperationException uoe) {
            return false;
        }
    }

    static {
        Vector<? extends Image> icons = new Vector<Image>();
        for (String filename : new String[]{"ServiceGuiIcon16.png", "ServiceGuiIcon32.png", "ServiceGuiIcon48.png"}) {
            try {
                BufferedImage img = ImageIO.read(Images.class.getResource(filename));
                icons.add(img);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        PROGRAM_ICONS = icons;
    }
}

