/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.jac.servicegui;

import ch.bruker.jac.servicegui.SGUtils;
import ch.bruker.jac.servicegui.systems.JacType;
import ch.bruker.jac.servicegui.systems.Settings;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableSet;
import java.awt.Dimension;
import java.awt.Point;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;

public class RunnerArguments {
    boolean developerGui = false;
    boolean maximized = false;
    boolean undecorated = false;
    boolean alwaysOnTop = false;
    boolean noTimeServer = false;
    Point position = null;
    Dimension size = null;
    JacType systemType = null;
    InetAddress ipAddress = null;
    int port = 0;
    String proxyPath = null;
    File dataFolder = null;
    ExportProps exportingProperties = null;
    GuiProps guiProps = null;
    String soapOrCorba = null;
    String openAtPath = null;
    String initialUser = null;
    String initialPassword = null;
    String initialUserLevel = null;
    File logDestination = null;

    public void parse(String[] args) {
        boolean anyArguments;
        Pattern openAt = Pattern.compile("-openat=\"?(.*)\"?");
        Pattern systemTypePattern = Pattern.compile("-type=\"?(.*)\"?");
        Pattern ipAddressPattern = Pattern.compile("-ip=(.*)");
        Pattern portPattern = Pattern.compile("-port=(.*)");
        Pattern proxyPathPattern = Pattern.compile("-proxyPath=\"?(.*)\"?");
        Pattern dataFolderPattern = Pattern.compile("-datafolder=\"?(.*)\"?");
        Pattern programLogfilePattern = Pattern.compile("-log=\"?(.*)\"?");
        Pattern exportAddressPattern = Pattern.compile("-export=\"?(.*?)\"?,(.*?),(.*?),(.*?)");
        Pattern csvExportPattern = Pattern.compile("-csv=\"?(\\d+),?(.*)?\"?");
        Pattern connectionPattern = Pattern.compile("-connection=(soap|corba)");
        Pattern userPattern = Pattern.compile("-user=\"?(.*)\"?");
        Pattern passwordPattern = Pattern.compile("-password=\"?(.*)\"?");
        Pattern userLevelPattern = Pattern.compile("-userLevel=\"?(.*)\"?");
        Pattern developerGuiPattern = Pattern.compile("-devGui");
        Pattern undecoratedPattern = Pattern.compile("-undecorated");
        Pattern maximizedPattern = Pattern.compile("-maximized");
        Pattern alwaysOnTopPattern = Pattern.compile("-alwaysOnTop");
        Pattern positionPattern = Pattern.compile("-position=(\\d+),(\\d+)");
        Pattern sizePattern = Pattern.compile("-size=?(\\d+)x(\\d+)");
        Pattern noTimeServerPattern = Pattern.compile("-noTimeServer");
        for (String arg : args) {
            Matcher noTimeServerMatcher;
            Matcher sizeMatcher;
            Matcher positionMatcher;
            Matcher alwaysOnTopMatcher;
            Matcher maximizedMatcher;
            Matcher undecoratedMatcher;
            Matcher developerGuiMatcher;
            Matcher userLevelMatcher;
            Matcher passwordMatcher;
            Matcher userMatcher;
            Matcher connectionMatcher;
            Matcher exportAddressMatcher;
            Matcher programLogfileMatcher;
            Matcher dataFolderMatcher;
            Matcher proxyPathMatcher;
            Matcher portMatcher;
            Matcher ipAddressMatcher;
            Matcher systemTypeMatcher;
            Matcher openAtMatcher = openAt.matcher(arg);
            if (openAtMatcher.matches()) {
                this.openAtPath = openAtMatcher.group(1);
                Settings.openDialogPath.setOverride(this.openAtPath);
            }
            if ((systemTypeMatcher = systemTypePattern.matcher(arg)).matches()) {
                String systemTypeString = systemTypeMatcher.group(1);
                this.systemType = JacType.getByTypeName(systemTypeString);
            }
            if ((ipAddressMatcher = ipAddressPattern.matcher(arg)).matches()) {
                try {
                    String ipAddressString = ipAddressMatcher.group(1);
                    this.ipAddress = InetAddress.getByName(ipAddressString);
                }
                catch (UnknownHostException e) {
                    // empty catch block
                }
            }
            if ((portMatcher = portPattern.matcher(arg)).matches()) {
                try {
                    String portString = portMatcher.group(1);
                    this.port = Integer.parseInt(portString);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            if ((proxyPathMatcher = proxyPathPattern.matcher(arg)).matches()) {
                this.proxyPath = proxyPathMatcher.group(1);
            }
            if ((dataFolderMatcher = dataFolderPattern.matcher(arg)).matches()) {
                String dataFolderString = dataFolderMatcher.group(1);
                this.dataFolder = new File(dataFolderString);
            }
            if ((programLogfileMatcher = programLogfilePattern.matcher(arg)).matches()) {
                String programLogfileString = programLogfileMatcher.group(1);
                this.logDestination = new File(programLogfileString);
            }
            if ((exportAddressMatcher = exportAddressPattern.matcher(arg)).matches()) {
                try {
                    File path = new File(exportAddressMatcher.group(1));
                    boolean includeSysMsg = SGUtils.parseBoolean(exportAddressMatcher.group(2));
                    DateTime start = SGUtils.DATE_FORMATTER.parseDateTime(exportAddressMatcher.group(3));
                    DateTime end = SGUtils.DATE_FORMATTER.parseDateTime(exportAddressMatcher.group(4));
                    end = end.plusDays(1);
                    ExportFormat format = ExportFormat.SERVICE_GUI;
                    long interval = 0L;
                    ImmutableSet.Builder builder = ImmutableSet.builder();
                    ImmutableCollection params = null;
                    for (String argLocal : args) {
                        Matcher csvExportMatcher = csvExportPattern.matcher(argLocal);
                        if (!csvExportMatcher.matches()) continue;
                        format = ExportFormat.CSV;
                        interval = Long.parseLong(csvExportMatcher.group(1));
                        String paramsString = csvExportMatcher.group(2);
                        if (paramsString != null) {
                            String[] p = paramsString.split(",");
                            if (p.length == 0) {
                                builder.add("");
                            } else {
                                for (String s : p) {
                                    builder.add(s);
                                }
                            }
                        } else {
                            builder.add("");
                        }
                        params = builder.build();
                    }
                    this.exportingProperties = new ExportProps(path, new Interval((ReadableInstant)start, (ReadableInstant)end), includeSysMsg, format, interval, (Set<String>)((Object)params));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if ((connectionMatcher = connectionPattern.matcher(arg)).matches()) {
                this.soapOrCorba = connectionMatcher.group(1);
            }
            if ((userMatcher = userPattern.matcher(arg)).matches()) {
                this.initialUser = userMatcher.group(1);
            }
            if ((passwordMatcher = passwordPattern.matcher(arg)).matches()) {
                this.initialPassword = passwordMatcher.group(1);
            }
            if ((userLevelMatcher = userLevelPattern.matcher(arg)).matches()) {
                this.initialUserLevel = userLevelMatcher.group(1);
            }
            if ((developerGuiMatcher = developerGuiPattern.matcher(arg)).matches()) {
                this.developerGui = true;
            }
            if ((undecoratedMatcher = undecoratedPattern.matcher(arg)).matches()) {
                this.undecorated = true;
            }
            if ((maximizedMatcher = maximizedPattern.matcher(arg)).matches()) {
                this.maximized = true;
            }
            if ((alwaysOnTopMatcher = alwaysOnTopPattern.matcher(arg)).matches()) {
                this.alwaysOnTop = true;
            }
            if ((positionMatcher = positionPattern.matcher(arg)).matches()) {
                try {
                    this.position = new Point(Integer.parseInt(positionMatcher.group(1)), Integer.parseInt(positionMatcher.group(2)));
                }
                catch (NumberFormatException e) {
                    this.position = null;
                }
            }
            if ((sizeMatcher = sizePattern.matcher(arg)).matches()) {
                try {
                    this.size = new Dimension(Integer.parseInt(sizeMatcher.group(1)), Integer.parseInt(sizeMatcher.group(2)));
                }
                catch (NumberFormatException e) {
                    this.size = null;
                }
            }
            if (!(noTimeServerMatcher = noTimeServerPattern.matcher(arg)).matches()) continue;
            this.noTimeServer = true;
        }
        this.guiProps = new GuiProps(this.undecorated, this.maximized, this.alwaysOnTop, this.position, this.size);
        int nrOfValidArgs = (this.systemType == null ? 0 : 1) + (this.ipAddress == null ? 0 : 1) + (this.port == 0 ? 0 : 1) + (this.proxyPath == null ? 0 : 1) + (this.logDestination == null ? 0 : 1) + (this.exportingProperties == null ? 0 : (this.exportingProperties.exportFormat == ExportFormat.SERVICE_GUI ? 1 : 2)) + (this.soapOrCorba == null ? 0 : 1) + (this.openAtPath == null ? 0 : 1) + (this.initialUser == null ? 0 : 1) + (this.initialPassword == null ? 0 : 1) + (this.initialUserLevel == null ? 0 : 1) + (!this.developerGui ? 0 : 1) + (!this.undecorated ? 0 : 1) + (!this.maximized ? 0 : 1) + (!this.alwaysOnTop ? 0 : 1) + (this.position == null ? 0 : 1) + (this.size == null ? 0 : 1) + (!this.noTimeServer ? 0 : 1);
        if (nrOfValidArgs != args.length) {
            SGUtils.log("Recognized arguments: " + (this.systemType != null ? "system type, " : "") + (this.ipAddress != null ? "IP address, " : "") + (this.port != 0 ? "port, " : "") + (this.proxyPath != null ? "proxy path, " : "") + (this.logDestination != null ? "program logfile, " : "") + (this.exportingProperties != null ? "data exporting, " : "") + (this.soapOrCorba != null ? "connection, " : "") + (this.undecorated ? "undecorated, " : "") + (this.maximized ? " maximized, " : "") + (this.alwaysOnTop ? "alwaysOnTop, " : "") + (this.position != null ? "position, " : "") + (this.size != null ? "size, " : "") + (this.noTimeServer ? "noTimeServer, " : ""), new Object[0]);
            SGUtils.log("Warning: Not all arguments are valid. Args: " + Arrays.toString(args) + "\n" + "Possible arguments are:" + "\n" + "\t\t\t-openat=<path for open-dialogs>" + "\n" + "\t\t\t-type=<system type>" + "\n" + "\t\t\t-ip=<IP address>" + "\n" + "\t\t\t-port=<port> (for NAT)" + "\n" + "\t\t\t-proxyPath=<path>" + "(-ip also necessary, ip of proxy host)" + "\n" + "\t\t\t-log=<path>" + "\n" + "\t\t\t-export=<path>,<incl_sys_msg>,<startdate>,<enddate> (GMT, " + "MM/dd/yyyy" + ")" + "\n" + "\t\t\t-csv=<interval [s]>,<param1>,<param2>,... (csv export, only valid if used together with -export=...; params are optional, all parameters used if omitted)" + "\n" + "\t\t\t-undecorated" + "\n" + "\t\t\t-maximized, overrides -size" + "\n" + "\t\t\t-alwaysOnTop" + "\n" + "\t\t\t-position=<x>,<y> (top left corner, pixel)" + "\n" + "\t\t\t-size=<width>x<height> (pixel)" + "\n" + "\t\t\t-noTimeServer", new Object[0]);
        }
        boolean bl = anyArguments = this.systemType != null || this.ipAddress != null || this.port != 0 || this.proxyPath != null || this.dataFolder != null || this.exportingProperties != null || this.soapOrCorba != null || this.initialUser != null || this.initialPassword != null || this.initialUserLevel != null || this.developerGui || this.undecorated || this.maximized || this.alwaysOnTop || this.position != null || this.size != null || this.noTimeServer;
        if (!anyArguments) {
            SGUtils.log("No arguments passed.", new Object[0]);
        } else {
            SGUtils.log("Parsed arguments:", new Object[0]);
            if (this.systemType != null) {
                SGUtils.log("\tSystem Type: %s", new Object[]{this.systemType});
            }
            if (this.ipAddress != null) {
                SGUtils.log("\tIP Address: %s", this.ipAddress);
            }
            if (this.port != 0) {
                SGUtils.log("\tWeb-Port: %d", this.port);
            }
            if (this.proxyPath != null) {
                SGUtils.log("\tProxy Path: %s", this.proxyPath);
            }
            if (this.dataFolder != null) {
                SGUtils.log("\tData Folder: %s", this.dataFolder);
            }
            if (this.exportingProperties != null) {
                SGUtils.log("\tExport: %s", this.exportingProperties);
            }
            if (this.soapOrCorba != null) {
                SGUtils.log("\tSOAP/Corba preference: %s", this.soapOrCorba);
            }
            if (this.initialUser != null) {
                SGUtils.log("\tInintial user: %s", this.initialUser);
            }
            if (this.initialPassword != null) {
                SGUtils.log("\tInitial password: %s", "**************");
            }
            if (this.initialUserLevel != null) {
                SGUtils.log("\tInitial user level: %s", this.initialUserLevel);
            }
            if (this.developerGui) {
                SGUtils.log("\tLoading/Using developer gui", new Object[0]);
            }
            if (this.undecorated) {
                SGUtils.log("\tNo frame decoration", new Object[0]);
            }
            if (this.maximized) {
                SGUtils.log("\tMaximized gui", new Object[0]);
            }
            if (this.alwaysOnTop) {
                SGUtils.log("\tGui always on top", new Object[0]);
            }
            if (this.position != null) {
                SGUtils.log("\tGui position (x,y): %d,%d", this.position.x, this.position.y);
            }
            if (this.size != null) {
                SGUtils.log("\tGui size (width,height): %d,%d", this.size.width, this.size.height);
            }
            if (this.noTimeServer) {
                SGUtils.log("\tGui without local time information", new Object[0]);
            }
        }
    }

    public boolean developerLogin() {
        return this.initialUserLevel != null ? this.initialUserLevel.startsWith("dev") : false;
    }

    static class GuiProps {
        final boolean maximized;
        final boolean undecorated;
        final boolean alwaysOnTop;
        final Point position;
        final Dimension size;

        GuiProps(boolean undecorated, boolean maximized, boolean alwaysOnTop, Point position, Dimension size) {
            this.maximized = maximized;
            this.undecorated = undecorated;
            this.alwaysOnTop = alwaysOnTop;
            this.position = position;
            this.size = size;
        }

        GuiProps() {
            this(false, false, false, null, null);
        }
    }

    static class ExportProps {
        final File exportPath;
        final Interval span;
        final boolean includeSysMsgLog;
        ExportFormat exportFormat;
        final long csvInterval;
        final Set<String> csvParameters;

        public String toString() {
            MoreObjects.ToStringHelper tsh = MoreObjects.toStringHelper(this).add("destination", this.exportPath).add("range", this.span).add("format", (Object)this.exportFormat);
            if (this.exportFormat == ExportFormat.CSV) {
                tsh = tsh.add("csvInterval", this.csvInterval).add("csvParameters", this.csvParameters);
            }
            return tsh.toString();
        }

        ExportProps(File exportPath, Interval span, boolean includeSysMsgLog, ExportFormat format, long csvInterval, Set<String> csvParameters) {
            this.exportPath = exportPath;
            this.span = span;
            this.includeSysMsgLog = includeSysMsgLog;
            this.exportFormat = format;
            this.csvInterval = csvInterval;
            this.csvParameters = csvParameters;
        }
    }

    static enum ExportFormat {
        SERVICE_GUI,
        CSV;

    }
}

