/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.jac.servicegui;

import ch.bruker.jac.config.JacPublicDefinitions;
import ch.bruker.jac.servicegui.AppState;
import ch.bruker.jac.servicegui.Jac;
import ch.bruker.jac.servicegui.JacHandle;
import ch.bruker.jac.servicegui.JacServiceGui;
import ch.bruker.jac.servicegui.Manifest;
import ch.bruker.jac.servicegui.NatGatewayManagementPanel;
import ch.bruker.jac.servicegui.RunnerArguments;
import ch.bruker.jac.servicegui.SGUtils;
import ch.bruker.jac.servicegui.data.DataStore;
import ch.bruker.jac.servicegui.data.InvalidSourceException;
import ch.bruker.jac.servicegui.data.io.FileSource;
import ch.bruker.jac.servicegui.data.io.SftpSource;
import ch.bruker.jac.servicegui.data.io.Source;
import ch.bruker.jac.servicegui.data.io.SourceProperties;
import ch.bruker.jac.servicegui.net.JacDeviceScanner;
import ch.bruker.jac.servicegui.systems.Groups;
import ch.bruker.jac.servicegui.systems.JacType;
import ch.bruker.jac.servicegui.systems.Settings;
import ch.bruker.util.Agent;
import ch.bruker.util.BUtil;
import ch.bruker.util.Bis;
import ch.bruker.util.DualOutputStream;
import ch.bruker.util.DynamicSelectionDialog;
import ch.bruker.util.JOptionPaneTB;
import ch.bruker.util.ProgressTask;
import ch.bruker.util.SizeLimitedFileOutputStream;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import javax.swing.JFileChooser;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.format.DateTimeFormat;

public class Runner {
    private static final int XMX_MB = 512;
    private static final int XSS_MB = 1;
    private static final long MAX_SYSTEM_OUTPUT_FILE_SIZE = 0xA00000L;
    private static final File DEFAULT_SYSTEM_OUTPUT_FILE = new File(Settings.workingPath.getString() + "/logs/" + DateTimeFormat.forPattern("MMM dd HH-mm-ss").print(DateTime.now()) + ".log");
    private static final File TEMP_DIR = new File(Settings.workingPath.getString() + "/temp/");
    private static final int TEMP_DIR_ATTEMPTS = 10000;
    private static boolean developerGui = false;
    private static RunnerArguments.GuiProps guiProps = new RunnerArguments.GuiProps();
    private static boolean noTimeServer = false;
    private static File logDestination = null;
    private static File tempDir = null;
    private static final String DELETEME_FILENAME = "deleteme";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException, URISyntaxException {
        boolean runningFromJar;
        File serviceGuiJarFile;
        boolean agentJarLoadNecessary;
        block55: {
            block56: {
                block53: {
                    Runtime.getRuntime().addShutdownHook(new ShutdownThread());
                    long availableMemory = Runtime.getRuntime().maxMemory() / 1024L / 1024L;
                    RuntimeMXBean runtimeMxBean = ManagementFactory.getRuntimeMXBean();
                    List<String> vmArgs = runtimeMxBean.getInputArguments();
                    boolean xssSet = false;
                    for (String arg : vmArgs) {
                        if (!arg.startsWith("-Xss")) continue;
                        xssSet = true;
                    }
                    agentJarLoadNecessary = true;
                    String javaVersion = System.getProperty("java.version");
                    SGUtils.log("Java Runtime: %s (%s)", javaVersion, System.getProperty("java.home"));
                    SGUtils.log("Arguments: %s", vmArgs);
                    SGUtils.log("System: %s", System.getProperties().toString());
                    if (javaVersion.startsWith("1.")) {
                        agentJarLoadNecessary = false;
                    }
                    String serviceGuiJarPath = Runner.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath();
                    serviceGuiJarFile = new File(serviceGuiJarPath);
                    runningFromJar = serviceGuiJarPath.endsWith(".jar");
                    File tempServiceGuiJarFile = null;
                    Runner.conditionallyDeleteTempDirectory();
                    if (availableMemory >= 256L && xssSet) break block55;
                    if (!runningFromJar) break block56;
                    FileInputStream is = null;
                    FileOutputStream os = null;
                    try {
                        ImmutableCollection.ArrayBasedBuilder cmd = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add(System.getProperty("java.home") + "/bin/java")).add("-Xmx512M")).add("-Xss1M");
                        if (agentJarLoadNecessary) {
                            int length;
                            tempDir = Runner.createTempDir();
                            tempServiceGuiJarFile = new File(tempDir.getPath() + File.separatorChar + "JacServiceGui.jar");
                            if (tempServiceGuiJarFile.exists() && !tempServiceGuiJarFile.delete()) {
                                throw new IOException("Could not delete temp file: " + tempServiceGuiJarFile.getAbsolutePath());
                            }
                            byte[] buf = new byte[8192];
                            is = new FileInputStream(serviceGuiJarPath);
                            os = new FileOutputStream(tempServiceGuiJarFile);
                            while ((length = ((InputStream)is).read(buf)) > 0) {
                                ((OutputStream)os).write(buf, 0, length);
                            }
                            serviceGuiJarFile = tempServiceGuiJarFile;
                            ((ImmutableList.Builder)((ImmutableList.Builder)cmd).add("-jar")).add(tempServiceGuiJarFile.getAbsolutePath());
                        } else {
                            ((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)cmd).add("-cp")).add(serviceGuiJarPath)).add(Runner.class.getName());
                        }
                        ((ImmutableList.Builder)cmd).addAll(Arrays.asList(args));
                        ProcessBuilder pb = new ProcessBuilder((List<String>)((Object)((ImmutableList.Builder)cmd).build()));
                        pb.redirectErrorStream(true);
                        SGUtils.log("Restarting with explicit memory and stack size requirement: %d MB / %d MB", 512, 1);
                        SGUtils.log("Starting " + serviceGuiJarFile.getAbsolutePath(), new Object[0]);
                        Process process = pb.start();
                        ByteStreams.copy(process.getInputStream(), System.out);
                        try {
                            process.waitFor();
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        SGUtils.log("Exiting wrapping Runner.", new Object[0]);
                        System.exit(process.exitValue());
                        BUtil.closeIgnoringExceptions(is);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        break block53;
                    }
                    finally {
                        BUtil.closeIgnoringExceptions(is);
                        BUtil.closeIgnoringExceptions(os);
                    }
                    BUtil.closeIgnoringExceptions(os);
                }
                return;
            }
            SGUtils.err("Warning: Scarce memory or stack size not set or java version > 8, but will not restart as not running from a .jar.", new Object[0]);
        }
        final RunnerArguments runnerArguments = new RunnerArguments();
        runnerArguments.parse(args);
        LookAndFeel lafFallback = null;
        try {
            System.setProperty("java.awt.headless", "false");
            lafFallback = UIManager.getLookAndFeel();
            String lafName = UIManager.getSystemLookAndFeelClassName();
            for (UIManager.LookAndFeelInfo laf : UIManager.getInstalledLookAndFeels()) {
                if (!laf.getName().contains("GTK")) continue;
                lafName = laf.getClassName();
            }
            SGUtils.log("Look and feel: " + lafName, new Object[0]);
            UIManager.setLookAndFeel(lafName);
            UIManager.put("ToolTip.background", new Color(255, 255, 220));
            UIManager.put("swing.boldMetal", Boolean.FALSE);
        }
        catch (Exception e) {
            SGUtils.err(e.getMessage(), new Object[0]);
            e.printStackTrace();
            try {
                if (lafFallback != null) {
                    System.setProperty("java.awt.headless", "false");
                    String fallbackClassName = lafFallback.getClass().getName();
                    SGUtils.log("Look and feel fallback: " + fallbackClassName, new Object[0]);
                    UIManager.setLookAndFeel(fallbackClassName);
                    UIManager.put("ToolTip.background", new Color(255, 255, 220));
                    UIManager.put("swing.boldMetal", Boolean.FALSE);
                }
            }
            catch (Exception e2) {
                SGUtils.err(e2.getMessage(), new Object[0]);
                e2.printStackTrace();
            }
        }
        System.setProperty("java.net.preferIPv4Stack", "true");
        try {
            logDestination = DEFAULT_SYSTEM_OUTPUT_FILE;
            File systemOutputFile = runnerArguments.logDestination == null ? DEFAULT_SYSTEM_OUTPUT_FILE : runnerArguments.logDestination;
            Files.createParentDirs(systemOutputFile);
            systemOutputFile.delete();
            SizeLimitedFileOutputStream lfos = new SizeLimitedFileOutputStream(0xA00000L, systemOutputFile);
            SGUtils.log("Logging to %s.", systemOutputFile.getAbsolutePath());
            System.setOut(new PrintStream(new DualOutputStream(lfos, System.out), true));
            System.setErr(new PrintStream(new DualOutputStream(lfos, System.err), true));
            logDestination = systemOutputFile;
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
        SGUtils.log("JAC Service GUI %s", Manifest.versionString());
        SGUtils.log("Operating System: %s %s %s", System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch"));
        if (agentJarLoadNecessary && runningFromJar) {
            ZipFile jarFile = null;
            try {
                if (tempDir == null || !tempDir.exists()) {
                    tempDir = Runner.createTempDir();
                }
                jarFile = new JarFile(serviceGuiJarFile);
                Enumeration<JarEntry> e = ((JarFile)jarFile).entries();
                while (e.hasMoreElements()) {
                    JarEntry entry = e.nextElement();
                    if (!entry.getName().startsWith("lib/jax/") || !entry.getName().endsWith(".jar")) continue;
                    InputStream is = null;
                    FileOutputStream os = null;
                    try {
                        int length;
                        is = ((JarFile)jarFile).getInputStream(entry);
                        File tempJarFile = new File(tempDir.getPath() + File.separatorChar + entry.getName());
                        Files.createParentDirs(tempJarFile);
                        os = new FileOutputStream(tempJarFile);
                        byte[] buf = new byte[8192];
                        while ((length = is.read(buf)) > 0) {
                            ((OutputStream)os).write(buf, 0, length);
                        }
                        JarFile jarFileOut = new JarFile(tempJarFile);
                        Agent.appendJarFile(jarFileOut);
                    }
                    catch (Throwable throwable) {
                        BUtil.closeIgnoringExceptions(is);
                        BUtil.closeIgnoringExceptions(os);
                        throw throwable;
                    }
                    BUtil.closeIgnoringExceptions(is);
                    BUtil.closeIgnoringExceptions(os);
                }
                SGUtils.log("Libraries loaded.", new Object[0]);
            }
            catch (Exception e) {
                SGUtils.err("Error while loading libraries: ", e.getMessage());
                e.printStackTrace();
            }
            finally {
                if (jarFile != null) {
                    try {
                        jarFile.close();
                    }
                    catch (Exception ignore) {}
                }
            }
        }
        JacHandle system = null;
        SourceProperties sourceProperties = null;
        if (runnerArguments.dataFolder == null) {
            JacDeviceScanner scanner = new JacDeviceScanner(runnerArguments.systemType);
            if (runnerArguments.systemType != null || runnerArguments.ipAddress != null) {
                if (JacType.AV4I_BSMS.equals((Object)runnerArguments.systemType)) {
                    String bisStr = "$Bis,1,20150605,65536,SCU,1#$Prd,Z162978,00001,00.00,1,BCH,20150605#$Nam,AV4 SCU SPECTROMETER CONTROL UNIT#$BasicBoard,1.0,Z162832,00001,00.00,AV4 SCU SYSTEM CONTROL UNIT UG#$SwPackage,1.0,Z174489#$EndBis,E0,CC#";
                    Bis bis = new Bis("$Bis,1,20150605,65536,SCU,1#$Prd,Z162978,00001,00.00,1,BCH,20150605#$Nam,AV4 SCU SPECTROMETER CONTROL UNIT#$BasicBoard,1.0,Z162832,00001,00.00,AV4 SCU SYSTEM CONTROL UNIT UG#$SwPackage,1.0,Z174489#$EndBis,E0,CC#".getBytes());
                    Jac bsms = Jac.fromBis(bis);
                    system = runnerArguments.ipAddress != null ? new JacHandle(runnerArguments.ipAddress, 22, bsms) : new JacHandle(Groups.AV4I_BSMS.ipAddress, 22, bsms);
                } else {
                    scanner.scanForConnectedSystems(runnerArguments.ipAddress, runnerArguments.port, runnerArguments.proxyPath);
                    system = scanner.waitForFirst();
                }
                String spec = ((Serializable)MoreObjects.firstNonNull(runnerArguments.systemType, runnerArguments.ipAddress)).toString();
                if (runnerArguments.proxyPath != null) {
                    spec = spec + ", path= " + runnerArguments.proxyPath;
                }
                if (system == null) {
                    String msg = "No matching system found (" + spec + "). Terminating.";
                    JOptionPaneTB.showMessageDialog(null, msg, "No matching system", 0, SGUtils.PROGRAM_ICONS);
                    SGUtils.log(msg, new Object[0]);
                    System.exit(ReturnErrorCode.NO_MATCHING_SYSTEM.ordinal());
                }
            } else {
                String text = "<html>Please choose the data source:<br/>(Either a connected system or a local log file)</html>";
                List<String> options = Collections.singletonList("Local Log File\u2026");
                DynamicSelectionDialog dialog = new DynamicSelectionDialog(text, options, scanner);
                NatGatewayManagementPanel panel = new NatGatewayManagementPanel(scanner);
                dialog.addPanel(panel);
                scanner.setListener(dialog);
                scanner.scanForConnectedSystems(null, 0, null);
                Object selection = dialog.show(null, SGUtils.PROGRAM_ICONS);
                if (selection == null) {
                    System.exit(ReturnErrorCode.INVALID_DESTINATION_DIR.ordinal());
                }
                if (selection.equals("Local Log File\u2026")) {
                    runnerArguments.dataFolder = Runner.showOpenDialog(null);
                    if (runnerArguments.dataFolder == null) {
                        System.exit(ReturnErrorCode.INVALID_DESTINATION_DIR.ordinal());
                    }
                } else if (selection instanceof File) {
                    system = null;
                    runnerArguments.dataFolder = (File)selection;
                } else {
                    system = (JacHandle)selection;
                }
            }
        }
        if (system != null) {
            sourceProperties = JacType.AV4I_BSMS.equals((Object)system.jac.type) ? SourceProperties.AV4I_BSMS().attachInstance(system.jac) : SourceProperties.JAC(system.jac.productId, system.jac.serialNumber);
        }
        final JacHandle finalSystem = system;
        final SourceProperties finalSourceProperties = sourceProperties;
        developerGui = runnerArguments.developerGui;
        guiProps = runnerArguments.guiProps;
        noTimeServer = runnerArguments.noTimeServer;
        new ProgressTask<Source>(null){

            @Override
            public void error(ExecutionException e) {
                super.error(e);
                if (e.getCause() instanceof InvalidSourceException) {
                    ((InvalidSourceException)e.getCause()).showAlert();
                    System.exit(ReturnErrorCode.UNEXPECTED_ERROR.ordinal());
                } else {
                    Runner.reportAndExit(e.getCause(), logDestination);
                }
            }

            @Override
            public Source work() throws Exception {
                if (runnerArguments.dataFolder != null) {
                    ProgressTask.update("Loading logfile\u2026");
                    return FileSource.create(runnerArguments.dataFolder);
                }
                ProgressTask.update("Connecting with " + finalSystem.jac.type.name + "\u2026");
                return SftpSource.create(finalSourceProperties, finalSystem.address.getHostAddress(), finalSystem.port, finalSystem.proxyPath, finalSystem.localAddress);
            }

            @Override
            public void done(Source source) {
                if (source == null) {
                    System.exit(ReturnErrorCode.DATA_CORRUPT.ordinal());
                }
                if (runnerArguments.exportingProperties != null) {
                    Runner.headless(source, runnerArguments.exportingProperties, noTimeServer);
                    return;
                }
                Runner.incarnate(source, runnerArguments.initialUser, runnerArguments.initialPassword, runnerArguments.developerLogin(), developerGui, guiProps, noTimeServer, logDestination);
            }
        }.start("Fetch data\u2026");
    }

    public static void headless(Source source, RunnerArguments.ExportProps props, boolean noTimeServer) {
        String msg;
        if (props.exportPath.isDirectory()) {
            msg = "Path is a directory, file cannot be written.";
            SGUtils.log(msg, new Object[0]);
            JOptionPaneTB.showMessageDialog(null, msg, "Export failed", 0, SGUtils.PROGRAM_ICONS);
            System.exit(ReturnErrorCode.INVALID_DESTINATION_DIR.ordinal());
        }
        if (props.exportPath.exists() && !props.exportPath.canWrite()) {
            msg = "File cannot be written.";
            SGUtils.log(msg, new Object[0]);
            JOptionPaneTB.showMessageDialog(null, msg, "Export failed", 0, SGUtils.PROGRAM_ICONS);
            System.exit(ReturnErrorCode.INVALID_DESTINATION_DIR.ordinal());
        }
        AppState appState = new AppState(source.origin.type, noTimeServer);
        appState.updates.register(appState);
        DataStore dataStore = new DataStore(appState, source, props.exportFormat != RunnerArguments.ExportFormat.CSV);
        appState.bindDataStore(dataStore, source.api != null);
        if (props.exportFormat == RunnerArguments.ExportFormat.CSV) {
            dataStore.exportCsv(props.csvParameters, props.span, true, Duration.standardSeconds(props.csvInterval), props.exportPath);
        } else {
            dataStore.export(null, Collections.singleton(""), props.span, null, props.exportPath);
        }
        SGUtils.log("Export complete. Terminating.", new Object[0]);
        System.exit(ReturnErrorCode.NO_ERROR.ordinal());
    }

    public static void incarnate(Source source) {
        Runner.incarnate(source, null, null, false, developerGui, guiProps, noTimeServer, logDestination);
    }

    public static void incarnate(final Source source, final String user, final String password, final boolean developer, final boolean finalDeveloperGui, final RunnerArguments.GuiProps finalGuiProps, final boolean finalNoTimeServer, final File logDestination) {
        SGUtils.log("Loading data and GUI for %s.", source);
        new ProgressTask<JacServiceGui>(null){

            @Override
            public JacServiceGui work() {
                return new JacServiceGui(source, finalDeveloperGui, finalGuiProps, finalNoTimeServer);
            }

            @Override
            public void done(JacServiceGui gui) {
                gui.display(finalGuiProps);
                gui.login(user, password, developer ? JacPublicDefinitions.UserLevel.DEVELOPER : JacPublicDefinitions.UserLevel.SERVICE);
            }

            @Override
            public void error(ExecutionException e) {
                Runner.reportAndExit(e, logDestination);
            }
        }.start("Loading data for " + source);
    }

    static void reportAndExit(Throwable e, File logDestination) {
        e.printStackTrace();
        String msg = "<html><p>An unexpected Error occured during initialization. <br />Thank you for providing the logfile at:</p><p><br/><em>" + logDestination.getAbsolutePath() + "</em></p><p><br />for debugging purposes of this version.</p></html>";
        JOptionPaneTB.showMessageDialog(null, msg, "Unexpected Error", 0, SGUtils.PROGRAM_ICONS);
        System.exit(ReturnErrorCode.UNEXPECTED_ERROR.ordinal());
    }

    static File showOpenDialog(Component parent) {
        File path = new File(Settings.openDialogPath.getString());
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileFilter(new FileNameExtensionFilter("Exported JAC Log Files (.bin)", "bin"));
        fileChooser.setFileSelectionMode(0);
        fileChooser.setDialogTitle("Select a local log file to open");
        fileChooser.setCurrentDirectory(path);
        int returnVal = fileChooser.showOpenDialog(parent);
        if (returnVal == 0) {
            return fileChooser.getSelectedFile();
        }
        return null;
    }

    private static void conditionallyDeleteTempDirectory() {
        try {
            File[] tempDirs = TEMP_DIR.listFiles();
            if (tempDirs != null) {
                for (File temporaryDir : tempDirs) {
                    if (!Runner.deleteDirectoryApproved(temporaryDir)) continue;
                    Runner.deleteDirectoryRecursively(temporaryDir);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static boolean deleteDirectoryRecursively(File directoryToBeDeleted) {
        File[] allContents = directoryToBeDeleted.listFiles();
        if (allContents != null) {
            for (File file : allContents) {
                Runner.deleteDirectoryRecursively(file);
            }
        }
        return directoryToBeDeleted.delete();
    }

    private static boolean deleteDirectoryApproved(File directoryToBeChecked) {
        try {
            String creationTimeMillisString = directoryToBeChecked.getName().split("-")[0];
            long creationTimeMillis = Long.parseLong(creationTimeMillisString);
            if (System.currentTimeMillis() > creationTimeMillis + 1471228928L) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        File[] allContents = directoryToBeChecked.listFiles();
        if (allContents != null) {
            for (File file : allContents) {
                if (!file.getName().equals(DELETEME_FILENAME)) continue;
                return true;
            }
        }
        return false;
    }

    private static File createTempDir() {
        File baseDir = TEMP_DIR;
        String baseName = System.currentTimeMillis() + "-";
        for (int counter = 0; counter < 10000; ++counter) {
            File tempDir = new File(baseDir, baseName + counter);
            if (!tempDir.mkdirs()) continue;
            return tempDir;
        }
        throw new IllegalStateException("Failed to create directory within 10000 attempts (tried " + baseName + "0 to " + baseName + 9999 + ')');
    }

    static enum ReturnErrorCode {
        NO_ERROR,
        UNEXPECTED_ERROR,
        DATA_CORRUPT,
        ALREADY_RUNNING,
        NO_MATCHING_SYSTEM,
        INVALID_DESTINATION_DIR,
        EMPTY_RANGE;

    }

    static class ShutdownThread
    extends Thread {
        ShutdownThread() {
        }

        @Override
        public void run() {
            try {
                if (tempDir != null) {
                    File deleteMe = new File(tempDir.getPath() + File.separatorChar + Runner.DELETEME_FILENAME);
                    Files.touch(deleteMe);
                }
            }
            catch (Exception e) {
                SGUtils.err("Temp dir could not be marked for deletion: ", e.getMessage());
                e.printStackTrace();
            }
        }
    }
}

