/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.jac.servicegui;

import ch.bruker.jac.servicegui.net.JacDeviceScanner;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class NatGatewayManagementPanel
extends JPanel {
    private final JacDeviceScanner scanner;
    private final JTextField textField;
    private final JList list;
    private final DefaultListModel listModel = new DefaultListModel();

    public NatGatewayManagementPanel(JacDeviceScanner scanner) {
        this.scanner = scanner;
        GridBagLayout layout = new GridBagLayout();
        layout.columnWidths = new int[]{100, 20};
        layout.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        layout.rowHeights = new int[]{0, 40, 0};
        layout.rowWeights = new double[]{0.0, Double.MIN_VALUE, 0.0};
        this.setLayout(layout);
        this.setBorder(new TitledBorder(null, "Remote Spectrometers", 4, 2, null, null));
        final JCheckBox natOnly = new JCheckBox("Scan Remote Spectrometers Only");
        natOnly.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NatGatewayManagementPanel.this.fireNatGatewayOnlyScan(natOnly.isSelected());
            }
        });
        this.add((Component)natOnly, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 11, 1, new Insets(0, 5, 0, 5), 0, 0));
        JScrollPane scrollPane = new JScrollPane();
        this.add((Component)scrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.list = new JList(this.listModel);
        scrollPane.setViewportView(this.list);
        this.list.setVisibleRowCount(3);
        JButton btnRemove = new JButton("Remove");
        btnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String hostName = (String)NatGatewayManagementPanel.this.list.getSelectedValue();
                if (hostName != null) {
                    NatGatewayManagementPanel.this.listModel.removeElement(hostName);
                    NatGatewayManagementPanel.this.fireNatGatewayRemoved(hostName);
                }
            }
        });
        this.add((Component)btnRemove, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 11, 2, new Insets(5, 0, 5, 5), 0, 0));
        this.textField = new JTextField();
        this.textField.setColumns(10);
        this.add((Component)this.textField, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 18, 1, new Insets(0, 5, 5, 5), 0, 0));
        JButton btnAdd = new JButton("Add");
        btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String hostName = NatGatewayManagementPanel.this.textField.getText().trim();
                if (!hostName.isEmpty()) {
                    NatGatewayManagementPanel.this.listModel.addElement(hostName);
                    NatGatewayManagementPanel.this.fireNatGatewayAdded(hostName);
                }
            }
        });
        this.add((Component)btnAdd, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 18, 1, new Insets(0, 0, 5, 5), 0, 0));
        for (String ipAddress : scanner.getNatGatewayList()) {
            this.listModel.addElement(ipAddress);
        }
        natOnly.setSelected(scanner.getNatGatewayOnlyScan());
    }

    private void fireNatGatewayAdded(String natGateway) {
        this.scanner.natGatewayAdded(natGateway);
    }

    private void fireNatGatewayRemoved(String natGateway) {
        this.scanner.natGatewayRemoved(natGateway);
    }

    private void fireNatGatewayOnlyScan(boolean natOnly) {
        this.scanner.natGatewayOnlyScan(natOnly);
    }
}

