/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.jac.servicegui;

import ch.bruker.jac.servicegui.SGUtils;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class NamedThreadFactory
implements ThreadFactory {
    private static final AtomicInteger poolNumber = new AtomicInteger();
    public final ThreadGroup group;
    private final String name;
    private final int priority;

    public NamedThreadFactory(String name, int priority) {
        this.priority = priority;
        this.name = name;
        if (priority < 1 || priority > 10) {
            throw new IllegalArgumentException("Thread priority needs to be within 1..10");
        }
        this.group = new ThreadGroup(name + " Group"){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                super.uncaughtException(t, e);
            }
        };
    }

    public NamedThreadFactory(String name) {
        this(name, 5);
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread t = new Thread(this.group, r);
        t.setName(this.name + " " + poolNumber.getAndIncrement());
        t.setDaemon(false);
        t.setPriority(this.priority);
        t.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                SGUtils.err("Lost Thread '%s': %s", NamedThreadFactory.this.name, e.getMessage());
                e.printStackTrace();
            }
        });
        return t;
    }
}

