/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.jac.servicegui;

import ch.bruker.jac.config.JacPublicDefinitions;
import ch.bruker.jac.config.LocalAuth;
import ch.bruker.jac.servicegui.AppState;
import ch.bruker.jac.servicegui.SGUtils;
import ch.bruker.jac.servicegui.api.ApiTalker;
import ch.bruker.util.PasswordUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.joda.time.Period;

class LoginDialog
extends JDialog {
    private static final Period DEFAULT_EXPIRATION_PERIOD = Period.hours(12);
    private static final String CHALLENGE_USERNAME = "challengeUser";
    private final JTabbedPane tabbedPane;
    private final AppState appState;
    private final ApiTalker api;
    private Timer expirationTimer;
    final LoginTab serviceLogin;
    final LoginTab tempLogin;
    final LoginTab devLogin;
    private static TreeMap<String, String> developpers = new TreeMap();
    public static final String SALT = "5vNZqsEHqDMyB0ujNeGmYgepX";

    LoginDialog(Frame parent, AppState appState, ApiTalker api) {
        super((Window)parent, Dialog.ModalityType.DOCUMENT_MODAL);
        this.appState = appState;
        this.api = api;
        this.setResizable(false);
        this.setTitle("Login");
        this.setBounds(100, 100, 309, 230);
        this.tabbedPane = new JTabbedPane(1);
        this.getContentPane().add((Component)this.tabbedPane, "Center");
        this.serviceLogin = new LoginTab(JacPublicDefinitions.UserLevel.SERVICE);
        this.tabbedPane.addTab("Service", null, this.serviceLogin, null);
        this.tabbedPane.setMnemonicAt(this.tabbedPane.getTabCount() - 1, 83);
        this.serviceLogin.action.setText(this.serviceLogin.action.getText() + " Service");
        if (appState.getUserLevel().equals((Object)JacPublicDefinitions.UserLevel.SERVICE)) {
            this.tabbedPane.setSelectedComponent(this.serviceLogin);
        } else if (appState.getLastUserLevel().equals((Object)JacPublicDefinitions.UserLevel.SERVICE)) {
            this.tabbedPane.setSelectedComponent(this.serviceLogin);
            appState.clearLastUserLevel();
        }
        this.tempLogin = new LoginTab(null);
        this.tabbedPane.addTab("Temporary", null, this.tempLogin, null);
        this.tabbedPane.setMnemonicAt(this.tabbedPane.getTabCount() - 1, 84);
        if (appState.system.allowTempLogin) {
            int challenge = 0;
            if (appState.mode.isInteractive) {
                try {
                    challenge = api.getChallengeNumber();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                challenge = LocalAuth.getChallenge();
            }
            this.tempLogin.text.setText("Please enter the response key for this challenge:");
            this.tempLogin.nameLabel.setText("Challenge");
            this.tempLogin.nameField.setText(String.valueOf(challenge));
            this.tempLogin.nameField.setEditable(false);
            this.tempLogin.passwordLabel.setText("Response");
            this.tempLogin.passwordField.setEchoChar('\u0000');
            this.tempLogin.action.setText(this.tempLogin.action.getText() + " temporarily");
            this.tempLogin.action.removeActionListener(this.tempLogin.action.getActionListeners()[0]);
            this.tempLogin.action.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        JacPublicDefinitions.UserLevel level;
                        int response = Integer.parseInt(LoginDialog.this.tempLogin.passwordField.getText());
                        JacPublicDefinitions.UserLevel userLevel = level = response > 500000 ? JacPublicDefinitions.UserLevel.DEVELOPER : JacPublicDefinitions.UserLevel.SERVICE;
                        if (LoginDialog.this.tempLogin.login(LoginDialog.CHALLENGE_USERNAME, String.valueOf(response), level)) {
                            Period expirationTime = LoginDialog.this.getExpirationTime();
                            SGUtils.log("Logged in as %s for %s", new Object[]{level, SGUtils.PERIOD_FORMATTER.print(expirationTime)});
                            int millis = expirationTime.toStandardSeconds().getSeconds() * 1000;
                            LoginDialog.this.expirationTimer = new Timer(millis, new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    LoginDialog.this.tempLogin.logout();
                                }
                            });
                            LoginDialog.this.expirationTimer.setRepeats(false);
                            LoginDialog.this.expirationTimer.start();
                        }
                    }
                    catch (NumberFormatException nfe) {
                        LoginDialog.this.tempLogin.text.setText("<html><font color='red'>The entered response is not a number. Try again!</font></html>");
                        LoginDialog.this.tempLogin.passwordField.setText("");
                    }
                }
            });
            this.tempLogin.repaint();
        } else {
            this.tabbedPane.setEnabledAt(this.tabbedPane.getTabCount() - 1, false);
        }
        this.devLogin = new LoginTab(JacPublicDefinitions.UserLevel.DEVELOPER);
        this.tabbedPane.addTab("Developer", null, this.devLogin, null);
        this.tabbedPane.setMnemonicAt(this.tabbedPane.getTabCount() - 1, 68);
        this.devLogin.action.setText(this.devLogin.action.getText() + " Developer");
        if (appState.getUserLevel().equals((Object)JacPublicDefinitions.UserLevel.DEVELOPER)) {
            this.tabbedPane.setSelectedComponent(this.devLogin);
        } else if (appState.getLastUserLevel().equals((Object)JacPublicDefinitions.UserLevel.DEVELOPER)) {
            this.tabbedPane.setSelectedComponent(this.devLogin);
            appState.clearLastUserLevel();
        }
        AbstractAction escapeAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                LoginDialog.this.dispose();
            }
        };
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "ESCAPE_KEY");
        this.getRootPane().getActionMap().put("ESCAPE_KEY", escapeAction);
        this.setLocationRelativeTo(parent);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ((LoginTab)((LoginDialog)LoginDialog.this).tabbedPane.getSelectedComponent()).nameField.requestFocus();
            }
        });
    }

    void login(String user, String password, JacPublicDefinitions.UserLevel userLevel) {
        switch (userLevel) {
            case DEVELOPER: {
                this.devLogin.login(user, password, userLevel);
                break;
            }
            case SERVICE: {
                this.serviceLogin.login(user, password, userLevel);
                break;
            }
        }
    }

    private Period getExpirationTime() {
        try {
            int seconds = this.api.getConnection().getParameter((String)"SERVICE_EXPIRATION_TIME").value.Int32Val();
            return Period.seconds(seconds).normalizedStandard();
        }
        catch (Exception exception) {
            return DEFAULT_EXPIRATION_PERIOD;
        }
    }

    static {
        developpers.put("prod", "mmpjyPpyox2ZdX4m91qSmbKBIhEuMwWVs0QrndV+xAk=");
        developpers.put("zem", "syGT3QdPfjfFXFgjbAi4Hq4hYhMmgyIjtKDZErarQ78=");
        developpers.put("hen", "9HYTVA+3Tv8MfxuwfyUwSyoBGRzXcSPm6SVy1b6JENk=");
        developpers.put("msc", "t8Fumc+7XXneX25SQnZoeHx4TCBpnSPZ1FjTyI3ErCU=");
        developpers.put("scs", "8opjXAMo7C9khfnYauVUy0oZKTLv8bViJkaAb62WUsQ=");
        developpers.put("zos", "dkyo+WKxtvga1Haij+Zf7bKOHMM/FY9OqLW7DALlFRM=");
        developpers.put("bey", "ELoDXwZ18gxb/0cyZQ2D/amBeKHR9jJ2D9/YSt3uEIw=");
        developpers.put("wei", "4QYIn95Az2ZKtXYQ6FIaXXKCjEql60qcPpS84qZJsao=");
    }

    class LoginTab
    extends JPanel {
        private static final String NO_CONNECTION_MESSAGE = "<html><font color='red'>No connection to remote system!</font></html>";
        private static final String NO_SUCCESS_MESSAGE = "<html><font color='red'>Wrong username or password. Try again!</font></html>";
        public static final String NAN_MESSAGE = "<html><font color='red'>The entered response is not a number. Try again!</font></html>";
        JLabel text = new JLabel("Please provide username and password.");
        JLabel nameLabel = new JLabel("User");
        JTextField nameField = new JTextField();
        JLabel passwordLabel = new JLabel("Password");
        JPasswordField passwordField = new JPasswordField();
        JButton action = new JButton("Login");

        LoginTab(final JacPublicDefinitions.UserLevel level) {
            boolean loggedIn = LoginDialog.this.appState.getUserLevel().equals((Object)level);
            GridBagLayout layout = new GridBagLayout();
            layout.columnWidths = new int[]{20, 65, 100, 20, 0};
            layout.rowHeights = new int[]{65, 0, 0, 0, 0};
            layout.columnWeights = new double[]{0.0, 0.0, 1.0, 0.0, Double.MIN_VALUE};
            layout.rowWeights = new double[]{0.0, 0.0, 0.0, 1.0, Double.MIN_VALUE};
            this.setLayout(layout);
            GridBagConstraints _text = new GridBagConstraints();
            _text.fill = 2;
            _text.gridwidth = 2;
            _text.insets = new Insets(0, 0, 5, 5);
            _text.gridx = 1;
            _text.gridy = 0;
            this.add((Component)this.text, _text);
            GridBagConstraints _nameLabel = new GridBagConstraints();
            _nameLabel.insets = new Insets(0, 0, 5, 5);
            _nameLabel.anchor = 17;
            _nameLabel.gridx = 1;
            _nameLabel.gridy = 1;
            this.add((Component)this.nameLabel, _nameLabel);
            GridBagConstraints _nameField = new GridBagConstraints();
            _nameField.insets = new Insets(0, 0, 5, 5);
            _nameField.fill = 2;
            _nameField.gridx = 2;
            _nameField.gridy = 1;
            this.add((Component)this.nameField, _nameField);
            GridBagConstraints _passwordLabel = new GridBagConstraints();
            _passwordLabel.anchor = 17;
            _passwordLabel.insets = new Insets(0, 0, 5, 5);
            _passwordLabel.gridx = 1;
            _passwordLabel.gridy = 2;
            this.add((Component)this.passwordLabel, _passwordLabel);
            GridBagConstraints _passwordField = new GridBagConstraints();
            _passwordField.insets = new Insets(0, 0, 5, 5);
            _passwordField.fill = 2;
            _passwordField.gridx = 2;
            _passwordField.gridy = 2;
            this.add((Component)this.passwordField, _passwordField);
            this.action.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LoginTab.this.login(LoginTab.this.nameField.getText(), LoginTab.this.passwordField.getText(), level);
                }
            });
            GridBagConstraints _action = new GridBagConstraints();
            _action.anchor = 13;
            _action.insets = new Insets(0, 0, 0, 5);
            _action.gridx = 2;
            _action.gridy = 3;
            this.add((Component)this.action, _action);
            if (loggedIn) {
                this.text.setText("Currently logged in.");
                this.nameLabel.setEnabled(false);
                this.nameField.setEnabled(false);
                this.passwordLabel.setEnabled(false);
                this.passwordField.setEnabled(false);
                this.action.setText("Log out");
                this.action.removeActionListener(this.action.getActionListeners()[0]);
                this.action.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        LoginTab.this.logout();
                    }
                });
            }
            LoginDialog.this.tabbedPane.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (LoginDialog.this.tabbedPane.getSelectedComponent().equals(LoginTab.this)) {
                        LoginTab.this.getRootPane().setDefaultButton(LoginTab.this.action);
                    }
                    LoginTab.this.nameField.requestFocus();
                }
            });
        }

        boolean login(String name, String pw, JacPublicDefinitions.UserLevel level) {
            boolean success = false;
            if (LoginDialog.this.api == null) {
                if (name.equals(LoginDialog.CHALLENGE_USERNAME)) {
                    success = LocalAuth.verify(pw).equals((Object)level);
                } else {
                    switch (level) {
                        case SERVICE: {
                            success = PasswordUtils.generateSecurePassword(pw, LoginDialog.SALT).equals("m0NDv8AQRBF+AFN5CxooE3ISBWVmo9yHkflCZj5hlt0=");
                            break;
                        }
                        case DEVELOPER: {
                            success = PasswordUtils.generateSecurePassword(pw, LoginDialog.SALT).equals(developpers.get(name));
                        }
                    }
                }
            } else if (((LoginDialog)LoginDialog.this).appState.mode.isInteractive) {
                try {
                    success = LoginDialog.this.api.login(name, pw, level);
                }
                catch (ApiTalker.RemoteException e) {
                    this.text.setText(e.getCause().getMessage());
                    return false;
                }
            } else {
                this.text.setText(NO_CONNECTION_MESSAGE);
                return false;
            }
            if (success) {
                LoginDialog.this.appState.setUserLevel(level);
                if (LoginDialog.this.expirationTimer != null) {
                    LoginDialog.this.expirationTimer.stop();
                }
                LoginDialog.this.dispose();
            } else {
                this.text.setText(NO_SUCCESS_MESSAGE);
                this.passwordField.setText("");
            }
            return success;
        }

        void logout() {
            if (LoginDialog.this.api != null) {
                try {
                    LoginDialog.this.api.logout();
                }
                catch (ApiTalker.RemoteException remoteException) {
                    // empty catch block
                }
            }
            LoginDialog.this.appState.setUserLevel(JacPublicDefinitions.UserLevel.USER);
            LoginDialog.this.dispose();
        }
    }
}

