/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.jac.servicegui;

import ch.bruker.jac.config.JacPublicDefinitions;
import ch.bruker.jac.servicegui.AppState;
import ch.bruker.jac.servicegui.FileDropHandler;
import ch.bruker.jac.servicegui.GuiMode;
import ch.bruker.jac.servicegui.InfoPanel;
import ch.bruker.jac.servicegui.JacHandle;
import ch.bruker.jac.servicegui.LoginDialog;
import ch.bruker.jac.servicegui.Manifest;
import ch.bruker.jac.servicegui.NatGatewayManagementPanel;
import ch.bruker.jac.servicegui.Runner;
import ch.bruker.jac.servicegui.RunnerArguments;
import ch.bruker.jac.servicegui.SGUtils;
import ch.bruker.jac.servicegui.SettingsDialog;
import ch.bruker.jac.servicegui.Trigger;
import ch.bruker.jac.servicegui.data.DataStore;
import ch.bruker.jac.servicegui.data.Tag;
import ch.bruker.jac.servicegui.data.io.FileSource;
import ch.bruker.jac.servicegui.data.io.SftpSource;
import ch.bruker.jac.servicegui.data.io.Source;
import ch.bruker.jac.servicegui.data.io.SourceProperties;
import ch.bruker.jac.servicegui.graphical.GraphTab;
import ch.bruker.jac.servicegui.net.JacDeviceScanner;
import ch.bruker.jac.servicegui.status.StatusTab;
import ch.bruker.jac.servicegui.systems.JacType;
import ch.bruker.jac.servicegui.text.TextLogState;
import ch.bruker.jac.servicegui.text.TextLogTab;
import ch.bruker.jac.servicegui.timer.TimerTab;
import ch.bruker.util.DynamicSelectionDialog;
import ch.bruker.util.FixedOrderTabbedPane;
import ch.bruker.util.ProgressTask;
import ch.bruker.util.ReattachableFrame;
import com.google.common.collect.ImmutableList;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Locale;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import org.joda.time.DateTime;

public class JacServiceGui
extends JFrame {
    public static final int DEFAULT_PORT = 80;
    public static final String USER_HOME = System.getProperty("user.home");
    private Source source;
    private DataStore dataStore;
    private AppState appState;
    private FixedOrderTabbedPane tabbedPane;

    public static void main(String[] args) throws IOException, URISyntaxException {
        Runner.main(args);
    }

    JacServiceGui(Source source, boolean developerGui, RunnerArguments.GuiProps guiProps, boolean noTimeServer) {
        boolean AV4I_BSMS;
        if (guiProps.undecorated) {
            this.setUndecorated(true);
        }
        if (AV4I_BSMS = JacType.AV4I_BSMS.equals((Object)source.origin.type)) {
            this.setTitle(source + " - AV4i/BSMS Diagnostics " + Manifest.versionString());
        } else {
            this.setTitle(source + " - JAC Data Viewer and Service GUI " + Manifest.versionString());
        }
        System.setProperty("iiop.resolvehostname", "false");
        this.setDefaultCloseOperation(2);
        this.setIconImages(SGUtils.PROGRAM_ICONS);
        ToolTipManager.sharedInstance().setDismissDelay(20000);
        ToolTipManager.sharedInstance().setReshowDelay(100);
        Locale.setDefault(SGUtils.getLocale());
        JOptionPane.setDefaultLocale(SGUtils.getLocale());
        this.source = source;
        this.appState = new AppState(source.origin.type, noTimeServer);
        this.appState.updates.register(this.appState);
        this.appState.bindRootFrame(this);
        FileDropHandler fileDropHandler = new FileDropHandler();
        this.setTransferHandler(fileDropHandler);
        this.appState.dropFallback = fileDropHandler;
        this.appState.updates.register(this);
        this.createMenu(this.appState.updates, guiProps.undecorated, guiProps.alwaysOnTop);
        this.dataStore = new DataStore(this.appState, source);
        this.appState.bindDataStore(this.dataStore, AV4I_BSMS || source.api != null);
        TextLogState textLogState = new TextLogState(this.appState);
        this.appState.updates.register(textLogState);
        ProgressTask.update("Loading user interface\u2026");
        this.tabbedPane = new FixedOrderTabbedPane(1, 1);
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.tabbedPane.getPane(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 10, 10));
        int tabIdx = 0;
        GraphTab graphTab = new GraphTab(this.appState, textLogState);
        this.tabbedPane.add("Graphical Data", graphTab);
        this.tabbedPane.setMnemonicAt(tabIdx++, 71);
        this.appState.updates.register(graphTab);
        if (!AV4I_BSMS) {
            final StatusTab statusTab = new StatusTab(this.appState, source, developerGui);
            this.tabbedPane.add("Status", statusTab);
            this.tabbedPane.setMnemonicAt(tabIdx++, 83);
            statusTab.bindChangeListener();
            if (this.appState.mode.isInteractive) {
                source.api.bindBusy(new Runnable(){

                    @Override
                    public void run() {
                        statusTab.setBusy(true);
                    }
                });
                source.api.bindIdle(new Runnable(){

                    @Override
                    public void run() {
                        statusTab.setBusy(false);
                    }
                });
                source.api.bindConnectionBroken(new Runnable(){

                    @Override
                    public void run() {
                        JacServiceGui.this.appState.setConnected(false);
                    }
                });
            }
        }
        TextLogTab textLogTab = new TextLogTab(textLogState);
        this.tabbedPane.add("Text Log", textLogTab);
        this.tabbedPane.setMnemonicAt(tabIdx++, 76);
        if (source.origin.type.timerPars.size() > 0 && source.api != null) {
            TimerTab timerTab = new TimerTab(this.appState, source.api);
            this.tabbedPane.add("Timer", timerTab);
            this.tabbedPane.setMnemonicAt(tabIdx++, 84);
        }
        this.appState.updates.post(this.appState.cursorHeader);
        if (!guiProps.undecorated && !guiProps.alwaysOnTop) {
            this.tabbedPane.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent me) {
                    Rectangle rect = JacServiceGui.this.tabbedPane.getUI().getTabBounds(JacServiceGui.this.tabbedPane.getPane(), JacServiceGui.this.tabbedPane.getSelectedIndex());
                    if (rect != null && rect.contains(me.getPoint()) && me.getClickCount() == 2) {
                        JComponent tabComponent = (JComponent)JacServiceGui.this.tabbedPane.getSelectedComponent();
                        String title = JacServiceGui.this.tabbedPane.getTitleAt(JacServiceGui.this.tabbedPane.getSelectedIndex());
                        ReattachableFrame detached = new ReattachableFrame(title, tabComponent, JacServiceGui.this.tabbedPane);
                        detached.setIconImages(SGUtils.PROGRAM_ICONS);
                        detached.getContentPane().add(tabComponent);
                        detached.pack();
                        detached.setVisible(true);
                    }
                }
            });
        }
        if (guiProps.size != null) {
            this.setPreferredSize(guiProps.size);
        } else {
            Rectangle bounds = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getBounds();
            int width = Math.min(1600, Math.max(750, (int)bounds.getWidth()));
            int height = Math.min(900, Math.max(750, (int)bounds.getHeight()));
            this.setPreferredSize(new Dimension(width, height));
        }
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                JacServiceGui.this.shutdown();
            }
        });
        if (guiProps.undecorated && (guiProps.position != null || guiProps.size != null)) {
            this.addComponentListener(new MainFrameListener(guiProps));
        }
    }

    private void shutdown() {
        boolean lastWindowClosing = true;
        for (Frame frame : Frame.getFrames()) {
            if (frame == this || !(frame instanceof JacServiceGui) || !frame.isVisible()) continue;
            lastWindowClosing = false;
        }
        if (!lastWindowClosing) {
            this.appState.doAsync(new Runnable(){

                @Override
                public void run() {
                    JacServiceGui.this.dataStore.shutdown();
                }
            });
            return;
        }
        new ProgressTask(this.appState.getRootFrame()){

            public Object work() {
                JacServiceGui.this.dataStore.shutdown();
                return null;
            }

            public void done(Object result) {
                System.exit(0);
            }
        }.start("Shutting down\u2026");
    }

    public void display(RunnerArguments.GuiProps guiProps) {
        DateTime timeLineEnd = this.appState.getTimeLineEnd();
        this.appState.setCursor(timeLineEnd);
        if (this.appState.mode.isInteractive) {
            this.appState.setScopeOnCursor(0.9);
        }
        this.pack();
        if (guiProps.position != null) {
            this.setLocation(guiProps.position);
        }
        if (guiProps.maximized) {
            this.setExtendedState(6);
        }
        if (guiProps.alwaysOnTop) {
            this.setAlwaysOnTop(true);
        }
        this.setVisible(true);
    }

    void login(String user, String password, JacPublicDefinitions.UserLevel userLevel) {
        if (user != null && password != null && userLevel != null) {
            new LoginDialog((Frame)this, this.appState, this.source.api).login(user, password, userLevel);
        }
    }

    private void createMenu(final EventBus updates, boolean undecorated, boolean alwaysOnTop) {
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("File");
        menu.setMnemonic(70);
        menuBar.add(menu);
        JMenuItem prefs = new JMenuItem("Preferences\u2026", 69);
        prefs.setAccelerator(KeyStroke.getKeyStroke(44, 2));
        menu.add(prefs);
        prefs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new SettingsDialog(JacServiceGui.this.appState.getRootFrame(), ((JacServiceGui)JacServiceGui.this).appState.settings, ((JacServiceGui)JacServiceGui.this).appState.updates);
            }
        });
        JMenuItem login = new JMenuItem("Login\u2026", 76);
        menu.add(login);
        login.setAccelerator(KeyStroke.getKeyStroke(76, 2));
        login.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((JacServiceGui)JacServiceGui.this).appState.updates.post(new Trigger("loginDialog"));
            }
        });
        menu.addSeparator();
        JMenuItem connect_to = new JMenuItem("Connect to\u2026", 67);
        connect_to.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        connect_to.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JacDeviceScanner scanner = new JacDeviceScanner(null);
                DynamicSelectionDialog dialog = new DynamicSelectionDialog("Please select the system to connect:", ImmutableList.of(), scanner);
                NatGatewayManagementPanel panel = new NatGatewayManagementPanel(scanner);
                dialog.addPanel(panel);
                scanner.setListener(dialog);
                scanner.scanForConnectedSystems(null, 0, null);
                Object selection = dialog.show(JacServiceGui.this, SGUtils.PROGRAM_ICONS);
                if (selection == null) {
                    return;
                }
                JacHandle handle = (JacHandle)selection;
                Source source = null;
                try {
                    source = SftpSource.create(SourceProperties.JAC(handle.jac.productId, handle.jac.serialNumber), handle.address.getHostAddress(), handle.port, handle.proxyPath, handle.localAddress);
                }
                catch (IOException e1) {
                    SGUtils.log("Could not connect to system.", new Object[0]);
                    e1.printStackTrace();
                }
                Runner.incarnate(source);
            }
        });
        menu.add(connect_to);
        JMenuItem open_file = new JMenuItem("Open file\u2026", 79);
        open_file.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        open_file.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileSource source = null;
                while (true) {
                    File file = Runner.showOpenDialog(JacServiceGui.this);
                    try {
                        if (file == null) break;
                        source = FileSource.create(file);
                    }
                    catch (Exception x) {
                        x.printStackTrace();
                        if (file != null) continue;
                    }
                    break;
                }
                if (source == null) {
                    return;
                }
                Runner.incarnate(source);
            }
        });
        menu.add(open_file);
        menu.addSeparator();
        JMenuItem save_log = new JMenuItem("Save log as...", 83);
        save_log.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        save_log.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JacServiceGui.this.appState.showSaveDialog();
            }
        });
        menu.add(save_log);
        JMenuItem export_csv = new JMenuItem("Export as CSV\u2026", 69);
        export_csv.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        export_csv.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JacServiceGui.this.appState.showExportDialog();
            }
        });
        menu.add(export_csv);
        String exitString = undecorated ? "Close graph window" : "Exit";
        JMenuItem exit = new JMenuItem(exitString, 84);
        exit.setAccelerator(KeyStroke.getKeyStroke(87, 2));
        menu.add(exit);
        exit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JacServiceGui.this.shutdown();
                JacServiceGui.this.setVisible(false);
                JacServiceGui.this.dispose();
            }
        });
        menu = new JMenu("View");
        menu.setMnemonic(86);
        menuBar.add(menu);
        final JCheckBoxMenuItem tracking = new JCheckBoxMenuItem("Track newest data"){

            @Subscribe
            public void handleModeUpdate(GuiMode mode) {
                this.setSelected(mode.equals((Object)GuiMode.TRACKING));
                this.setEnabled(mode.isInteractive);
            }
        };
        tracking.setAccelerator(KeyStroke.getKeyStroke(84, 2));
        menu.add(tracking);
        tracking.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JacServiceGui.this.appState.setTracking(tracking.isSelected());
            }
        });
        this.appState.updates.register(tracking);
        JMenuItem info = new JMenuItem("System Info\u2026", 73);
        info.setAccelerator(KeyStroke.getKeyStroke(73, 2));
        menu.add(info);
        info.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                updates.post(new Trigger("systemInfoDialog"));
            }
        });
        if (!alwaysOnTop) {
            JMenuItem system_msg = new JMenuItem("JAC System Log\u2026", 77);
            system_msg.setAccelerator(KeyStroke.getKeyStroke(77, 2));
            menu.add(system_msg);
            system_msg.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    new ProgressTask<File>(JacServiceGui.this.appState.getRootFrame()){

                        @Override
                        public File work() throws IOException {
                            return JacServiceGui.this.dataStore.getSysMsg();
                        }

                        @Override
                        public void done(File result) {
                            try {
                                Desktop.getDesktop().open(result);
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    }.start("Loading System Messages\u2026");
                }
            });
        }
        menu.addSeparator();
        JMenuItem stats = new JMenuItem("Caching Performance\u2026", 77);
        stats.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        menu.add(stats);
        stats.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((JacServiceGui)JacServiceGui.this).dataStore.queueProducer.printStats(JacServiceGui.this);
            }
        });
        menu.addSeparator();
        JMenuItem clearRamCache = new JMenuItem("Clear cache", 67);
        clearRamCache.setAccelerator(KeyStroke.getKeyStroke(82, 128));
        menu.add(clearRamCache);
        clearRamCache.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                String msg = "After clearing the cache, the logfiles will be reprocessed. Unprocessed regions are highlighted with a red bar. Proceed?";
                int userAction = JOptionPane.showConfirmDialog(JacServiceGui.this, msg, "Clear & Reprocess", 2);
                if (userAction == 0) {
                    JacServiceGui.this.appState.doAsync(new Runnable(){

                        @Override
                        public void run() {
                            JacServiceGui.this.dataStore.invalidateDigest();
                            DataStore ds = new DataStore(JacServiceGui.this.appState, JacServiceGui.this.dataStore.getSource(), false);
                            JacServiceGui.this.appState.bindDataStore(ds, ((JacServiceGui)JacServiceGui.this).appState.mode.isInteractive, true);
                            JacServiceGui.this.dataStore = ds;
                            ((JacServiceGui)JacServiceGui.this).appState.updates.post(new Trigger("timeLineRepaint"));
                        }
                    });
                }
            }
        });
        JMenuItem clearLocalCopies = new JMenuItem("Retransmit remote files"){

            @Subscribe
            public void handleModeUpdate(GuiMode mode) {
                this.setEnabled(!mode.equals((Object)GuiMode.STANDALONE));
            }
        };
        this.appState.updates.register(clearLocalCopies);
        KeyStroke key = KeyStroke.getKeyStroke(82, 192);
        clearLocalCopies.setAccelerator(key);
        menu.add(clearLocalCopies);
        clearLocalCopies.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                String msg = "Local logfile copies of remotely connected JACs will be deleted and retransmitted (on demand). Proceed?";
                int userAction = JOptionPane.showConfirmDialog(JacServiceGui.this, msg, "Delete & Retransmit", 2);
                if (userAction == 0) {
                    ((JacServiceGui)JacServiceGui.this).source.archives.invalidateAll();
                }
            }
        });
        this.setJMenuBar(menuBar);
    }

    @Subscribe
    public void handleActiveTabUpdate(Class clazz) {
        for (int i = 0; i < this.tabbedPane.getPane().getTabCount(); ++i) {
            Component tab = this.tabbedPane.getPane().getComponentAt(i);
            if (!tab.getClass().equals(clazz)) continue;
            this.tabbedPane.setSelectedComponent(tab);
        }
    }

    @Subscribe
    public void handleTrigger(Trigger trigger) {
        if (!trigger.is("systemInfoDialog")) {
            return;
        }
        Collection<Tag<String>> systemInfos = this.dataStore.timeMap.systemInfo.getLower(this.appState.getCursor());
        if (systemInfos == null) {
            return;
        }
        Tag<String> info = systemInfos.iterator().next();
        InfoPanel infoPanel = new InfoPanel(this.appState.zonedDateTimeFormat().print(info.dateTime), info.getValue());
        Dimension d = infoPanel.getPreferredSize();
        JComponent displayedObject = infoPanel;
        if (d.width > 600 || d.height > 600) {
            JScrollPane infoScrollPane = new JScrollPane(infoPanel);
            infoScrollPane.setPreferredSize(new Dimension(350, 600));
            displayedObject = infoScrollPane;
        }
        JOptionPane.showMessageDialog(this, displayedObject, "System Information", -1);
    }

    @Subscribe
    public void handleTrigger_(Trigger trigger) {
        if (!trigger.is("loginDialog")) {
            return;
        }
        LoginDialog dialog = new LoginDialog((Frame)this, this.appState, this.source.api);
        dialog.setVisible(true);
    }

    private class MainFrameListener
    implements ComponentListener {
        private RunnerArguments.GuiProps guiProps;

        public MainFrameListener(RunnerArguments.GuiProps guiProps) {
            this.guiProps = guiProps;
        }

        @Override
        public synchronized void componentResized(ComponentEvent e) {
        }

        @Override
        public synchronized void componentMoved(ComponentEvent e) {
            Dimension size;
            Point location;
            if (this.guiProps.position != null && !(location = JacServiceGui.this.getLocation()).equals(this.guiProps.position)) {
                JacServiceGui.this.setLocation(this.guiProps.position);
            }
            if (this.guiProps.size != null && !(size = JacServiceGui.this.getSize()).equals(this.guiProps.size)) {
                JacServiceGui.this.setSize(this.guiProps.size);
            }
        }

        @Override
        public void componentShown(ComponentEvent e) {
        }

        @Override
        public void componentHidden(ComponentEvent e) {
        }
    }
}

