/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.jac.servicegui;

import ch.bruker.jac.servicegui.systems.JacType;
import ch.bruker.util.Bis;
import com.google.common.base.Objects;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public class Jac {
    public final JacType type;
    public final String productId;
    public final String serialNumber;

    private Jac(JacType type, String productId, String serialNumber) {
        this.type = type;
        this.productId = productId;
        this.serialNumber = serialNumber;
    }

    public static Jac fromBinName(String binName) {
        Pattern pattern = Pattern.compile("([^_]+)_([^_]+)_(\\d+)(_\\d+_\\d+)?_(Log|Light).*\\.bin");
        Matcher m = pattern.matcher(binName);
        if (!m.matches()) {
            throw new IllegalArgumentException("Invalid log file name");
        }
        JacType system = JacType.getByFsName(m.group(1));
        if (system == null) {
            throw new IllegalArgumentException("No such system type known: " + m.group(1));
        }
        return new Jac(system, m.group(2), m.group(3));
    }

    public static Jac fromBis(Bis bis) {
        JacType system = JacType.NONE;
        Bis.ProductionGroup pg = bis.productionGroup;
        if (pg.getProductID().equals("Z162978")) {
            system = JacType.AV4I_BSMS;
        } else {
            Bis.Group typeGroup = bis.getGroupList("Type").get(0);
            int typeCode = typeGroup.getIntegerEntry(0);
            system = JacType.getByID(typeCode);
        }
        return new Jac(system, pg.getProductID(), pg.getSerialNumber());
    }

    public static Jac fromBinContent(ZipFile bin) throws IOException {
        Enumeration<? extends ZipEntry> entries = bin.entries();
        InputStream stream = null;
        while (entries.hasMoreElements()) {
            ZipEntry entry_;
            ZipEntry entry = entries.nextElement();
            if (entry.getName().endsWith("Current.xml")) {
                stream = bin.getInputStream(entry);
                break;
            }
            if (!entry.getName().matches(".*\\d{10}_\\d{10}.zip")) continue;
            ZipInputStream in = new ZipInputStream(bin.getInputStream(entry));
            while (!(entry_ = in.getNextEntry()).getName().equals("Header.xml")) {
            }
            stream = in;
            break;
        }
        if (stream == null) {
            throw new IllegalStateException("No Current.xml found");
        }
        Scanner scanner = new Scanner(stream);
        try {
            Pattern pattern = Pattern.compile("<(generator|hardware_id)>(.+)<\\/\\1>", 2);
            int generator = -1;
            String hardware_id = "";
            for (int i = 0; i < 2; ++i) {
                scanner.findWithinHorizon(pattern, 0);
                MatchResult m = scanner.match();
                if (m.group(1).equals("generator")) {
                    generator = Integer.parseInt(m.group(2));
                }
                if (!m.group(1).equals("hardware_id")) continue;
                hardware_id = m.group(2);
            }
            String[] chunks = hardware_id.split("_", 2);
            if (generator == -1) {
                throw new IllegalStateException("Generator tag not found in header.");
            }
            if (hardware_id.isEmpty()) {
                throw new IllegalStateException("Hardware-ID tag not found in header.");
            }
            return new Jac(JacType.getByID(generator), chunks[0], chunks[1]);
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalStateException("Could not find generator and hardware-ID in header");
        }
        catch (NoSuchElementException e) {
            throw new IllegalStateException("Could not find generator and hardware-ID in header");
        }
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.type, this.productId, this.serialNumber});
    }

    public boolean equals(Object that) {
        return that instanceof Jac && this.hashCode() == that.hashCode();
    }

    public String getFsCompatibleLabel() {
        return this.type.getFsName() + " (" + this.productId + "-" + this.serialNumber + ")";
    }

    public String toString() {
        return this.type.name + " (" + this.productId + "-" + this.serialNumber + ")";
    }
}

