/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.jac.servicegui;

import ch.bruker.jac.config.JacPublicDefinitions;
import ch.bruker.jac.servicegui.AnimatedToggleButton;
import ch.bruker.jac.servicegui.AppState;
import ch.bruker.jac.servicegui.GuiMode;
import ch.bruker.jac.servicegui.SGUtils;
import ch.bruker.jac.servicegui.Trigger;
import ch.bruker.jac.servicegui.data.FlashWriteEventData;
import ch.bruker.jac.servicegui.img.Images;
import ch.bruker.util.IconButton;
import ch.bruker.util.JDateTimeField;
import com.google.common.eventbus.Subscribe;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import org.joda.time.DateTime;

public class GlobalPanel
extends JPanel {
    private final AppState appState;
    private final ImageIcon MODE_ICON_BLUE = new ImageIcon(Images.class.getResource("LiveModeBlue.png"));
    private final ImageIcon MODE_ICON_RED = new ImageIcon(Images.class.getResource("LiveModeRed.png"));
    private final ImageIcon MODE_ICON_GREEN = new ImageIcon(Images.class.getResource("LiveModeGreen.png"));
    private final ImageIcon NO_SAVE_ICON = new ImageIcon(Images.class.getResource("no_save_3.png"));
    private AbstractButton trackingButton;
    private JLabel connectionLabel;
    private JLabel noSaveLabel;
    private JLabel userLevelLabel;
    private JLabel cursorTimeLabel;
    private JDateTimeField cursorTimeTextField;

    public GlobalPanel(final AppState appState, JComponent ... extras) {
        this.appState = appState;
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0, 0, 222, 0, 0, 0, 0, 0};
        this.setLayout(gridBagLayout);
        GridBagConstraints constraints = SGUtils.createDefaultGridBagConstraints(4, 4);
        constraints.fill = 1;
        IconButton loginButton = new IconButton("Login", "key.png");
        loginButton.setPreferredSize(new Dimension(30, 20));
        loginButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                appState.updates.post(new Trigger("loginDialog"));
            }
        });
        this.add((Component)loginButton, constraints);
        this.userLevelLabel = new JLabel("");
        this.add((Component)this.userLevelLabel, constraints);
        this.userLevelLabel.setToolTipText("Currently logged in as\u2026");
        this.add((Component)new JSeparator(1), constraints);
        this.connectionLabel = new JLabel(this.MODE_ICON_BLUE);
        this.connectionLabel.setHorizontalAlignment(2);
        this.connectionLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                appState.updates.post(new Trigger("systemInfoDialog"));
            }
        });
        this.add((Component)this.connectionLabel, constraints);
        this.noSaveLabel = new JLabel();
        this.noSaveLabel.setHorizontalAlignment(4);
        this.noSaveLabel.setToolTipText("<html>Storing to the external flash is disabled or not possible.<br>Configuration changes and log files will be saved as soon as storing is enabled and possible again.<br>After startup or after a power outage, this may take up to half an hour.</html>");
        this.add((Component)this.noSaveLabel, constraints);
        if (extras.length > 0) {
            FlowLayout layout = new FlowLayout();
            layout.setVgap(0);
            JPanel toolBar = new JPanel(layout);
            for (JComponent extra : extras) {
                toolBar.add(extra);
            }
            this.add((Component)new JSeparator(1), constraints);
            this.add(toolBar);
        }
        constraints.weightx = 1.0;
        this.add(Box.createGlue(), constraints);
        constraints.weightx = 0.0;
        this.cursorTimeLabel = new JLabel("Cursor time (GMT):");
        this.cursorTimeLabel.setHorizontalAlignment(2);
        this.add((Component)this.cursorTimeLabel, constraints);
        this.cursorTimeTextField = new JDateTimeField(SGUtils.DATE_TIME_FORMATTER);
        this.cursorTimeTextField.setPreferredSize(new Dimension(130, 0));
        this.cursorTimeTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                appState.setCursor(GlobalPanel.this.cursorTimeTextField.getDateTime());
                appState.setScopeOnCursor(0.5);
                GlobalPanel.this.getParent().requestFocusInWindow();
            }
        });
        this.add((Component)this.cursorTimeTextField, constraints);
        this.trackingButton = new AnimatedToggleButton("Track newest Data (Ctrl+T)", "GoToEnd.png", "Tracking", ".png");
        this.trackingButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean isTrack;
                boolean doTrack = e.getStateChange() == 1;
                if (doTrack == (isTrack = appState.isMode(GuiMode.TRACKING))) {
                    return;
                }
                appState.setTracking(doTrack);
                if (doTrack) {
                    appState.setCursor(appState.getTimeLineEnd());
                    if (!appState.getScope().contains(appState.getCursor())) {
                        appState.setScopeOnCursor(0.9);
                    }
                    if (appState.isMode(GuiMode.LIVE_DISCONNECTED)) {
                        GlobalPanel.this.trackingButton.setSelected(false);
                        GlobalPanel.this.getParent().requestFocusInWindow();
                    }
                }
            }
        });
        this.add((Component)this.trackingButton, constraints);
        this.handleCursorUpdate(appState.getCursor());
        this.handleModeUpdate(appState.mode);
        this.handleUserLevelUpdate(appState.getUserLevel());
    }

    @Subscribe
    public void handleCursorUpdate(DateTime newCursorTime) {
        this.cursorTimeLabel.setText("Cursor time (" + this.appState.getConfiguredTimeZone() + "):");
        this.cursorTimeTextField.setText(this.appState.zonedDateTimeFormat().print(newCursorTime));
    }

    public void setExtrasInset(int inset) {
        GridBagLayout layout = (GridBagLayout)this.getLayout();
        int[] widths = layout.getLayoutDimensions()[0];
        layout.columnWidths[3] = inset - widths[0] - widths[1] - widths[2];
        this.setLayout(layout);
        this.revalidate();
        this.repaint();
    }

    @Subscribe
    public void handleUserLevelUpdate(JacPublicDefinitions.UserLevel newUserLevel) {
        String text;
        switch (newUserLevel) {
            case DEVELOPER: {
                text = "Developer";
                break;
            }
            case SERVICE: {
                text = "Service";
                break;
            }
            default: {
                text = "User";
            }
        }
        this.userLevelLabel.setText(text);
    }

    @Subscribe
    public void handleModeUpdate(GuiMode mode) {
        this.trackingButton.setSelected(this.appState.isMode(GuiMode.TRACKING));
        Container parent = this.getParent();
        if (parent != null) {
            parent.requestFocusInWindow();
        }
        this.cursorTimeTextField.setEditable(!mode.equals((Object)GuiMode.TRACKING));
        switch (mode) {
            case TRACKING: 
            case LIVE: {
                this.connectionLabel.setIcon(this.MODE_ICON_GREEN);
                this.connectionLabel.setText("Connected with " + this.appState.system.toString());
                break;
            }
            case TRACKING_DISCONNECTED: 
            case LIVE_DISCONNECTED: {
                this.connectionLabel.setIcon(this.MODE_ICON_RED);
                this.connectionLabel.setText("Connection lost");
                this.noSaveLabel.setIcon(null);
                break;
            }
            case STANDALONE: {
                this.connectionLabel.setIcon(this.MODE_ICON_BLUE);
                this.connectionLabel.setText("Standalone");
                this.noSaveLabel.setIcon(null);
            }
        }
    }

    @Subscribe
    public void handleFlashWritingAllowedUpdate(FlashWriteEventData data) {
        if (data.usbFlashWritingAllowed) {
            if (this.noSaveLabel.getIcon() != null) {
                this.noSaveLabel.setIcon(null);
            }
        } else if (this.noSaveLabel.getIcon() == null) {
            this.noSaveLabel.setIcon(this.NO_SAVE_ICON);
        }
    }
}

