/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.jac.servicegui;

import ch.bruker.jac.servicegui.Runner;
import ch.bruker.jac.servicegui.SGUtils;
import ch.bruker.jac.servicegui.TransferHandler_;
import ch.bruker.jac.servicegui.data.InvalidSourceException;
import ch.bruker.jac.servicegui.data.io.FileSource;
import ch.bruker.util.JOptionPaneTB;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executors;
import javax.swing.JOptionPane;
import javax.swing.TransferHandler;

public class FileDropHandler
extends TransferHandler_ {
    private final FileDropCallback callback;
    public static final FileDropCallback INCARNATE = new FileDropCallback(){

        @Override
        public void process(File file) {
            try {
                FileSource source = FileSource.create(file);
                Runner.incarnate(source);
            }
            catch (InvalidSourceException e) {
                e.showAlert();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    };

    public FileDropHandler(FileDropCallback callback) {
        this.callback = callback;
    }

    public FileDropHandler() {
        this.callback = INCARNATE;
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        for (DataFlavor flavor : support.getDataFlavors()) {
            if (!flavor.isFlavorJavaFileListType()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support) {
        List files;
        try {
            files = (List)support.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
        }
        catch (UnsupportedFlavorException ex) {
            return false;
        }
        catch (IOException ex) {
            return false;
        }
        if (files.size() > 1) {
            String msg = "Please drop a single file to open.";
            JOptionPaneTB.showMessageDialog(JOptionPane.getRootFrame(), msg, "Multiple files dropped", 2, SGUtils.PROGRAM_ICONS);
            return false;
        }
        final File logFile = (File)files.get(0);
        Executors.newSingleThreadExecutor().submit(new Runnable(){

            @Override
            public void run() {
                FileDropHandler.this.callback.process(logFile);
            }
        });
        return true;
    }

    public static abstract class FileDropCallback {
        public abstract void process(File var1);
    }
}

