/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.jac.servicegui;

import java.awt.Color;

public class Colors {
    public static float getLuma(Color c2) {
        int r = c2.getRed();
        int g = c2.getGreen();
        int b2 = c2.getBlue();
        return (float)((double)r * 0.299 + (double)g * 0.587 + (double)b2 * 0.114) / 255.0f;
    }

    public static Color fixLuma(Color c2, float luma) {
        float maxComponent;
        int r = c2.getRed();
        int g = c2.getGreen();
        int b2 = c2.getBlue();
        float f = luma / Colors.getLuma(c2);
        if ((double)(maxComponent = Math.max(Math.max((float)r * (f /= 255.0f), (float)g * f), (float)b2 * f)) > 1.0) {
            f /= maxComponent;
        }
        return new Color((float)r * f, (float)g * f, (float)b2 * f);
    }

    public static float getSaturation(Color c2) {
        int r = c2.getRed();
        int g = c2.getGreen();
        int b2 = c2.getBlue();
        return Color.RGBtoHSB(r, g, b2, null)[1];
    }

    public static Color fixSaturation(Color c2, float saturation) {
        int r = c2.getRed();
        int g = c2.getGreen();
        int b2 = c2.getBlue();
        float[] hsb = Color.RGBtoHSB(r, g, b2, null);
        return Color.getHSBColor(hsb[0], saturation, hsb[2]);
    }

    public static Color fixOpacity(Color c2, float alpha) {
        int r = c2.getRed();
        int g = c2.getGreen();
        int b2 = c2.getBlue();
        return new Color(r, g, b2, (int)(alpha * 255.0f));
    }

    public static Color getHashColor(float saturation, float luma, Object toBeHashcoded) {
        int i = Colors.mapInteger(toBeHashcoded.hashCode());
        float hue = (float)i / 2.1474836E9f;
        Color c2 = Color.getHSBColor(hue, saturation, 1.0f);
        return Colors.fixLuma(c2, luma);
    }

    private static int mapInteger(int value) {
        value *= 1664525;
        value += 1013904223;
        value ^= value >>> 12;
        value ^= value << 7;
        value ^= value >>> 27;
        value *= 1103515245;
        return value += 12345;
    }

    private Colors() {
    }
}

