/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.jac.servicegui;

import ch.bruker.jac.config.JacPublicDefinitions;
import ch.bruker.jac.config.LocalAuth;
import ch.bruker.jac.servicegui.AbstractState;
import ch.bruker.jac.servicegui.GuiMode;
import ch.bruker.jac.servicegui.JacServiceGui;
import ch.bruker.jac.servicegui.NamedThreadFactory;
import ch.bruker.jac.servicegui.SGUtils;
import ch.bruker.jac.servicegui.Tab;
import ch.bruker.jac.servicegui.TransferHandlerProxy;
import ch.bruker.jac.servicegui.Trigger;
import ch.bruker.jac.servicegui.data.CacheVisualizer;
import ch.bruker.jac.servicegui.data.DataStore;
import ch.bruker.jac.servicegui.data.ExportCsv;
import ch.bruker.jac.servicegui.data.Header;
import ch.bruker.jac.servicegui.data.HwClock;
import ch.bruker.jac.servicegui.data.MetaPar;
import ch.bruker.jac.servicegui.data.ModifiableHeader;
import ch.bruker.jac.servicegui.data.Sample;
import ch.bruker.jac.servicegui.data.SaveDialog;
import ch.bruker.jac.servicegui.data.TimeLine;
import ch.bruker.jac.servicegui.data.TimeMap;
import ch.bruker.jac.servicegui.data.cache.Descriptor;
import ch.bruker.jac.servicegui.systems.JacType;
import ch.bruker.jac.servicegui.systems.Settings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.TransferHandler;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Duration;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;

public class AppState
extends AbstractState {
    private static HashMap<String, MetaPar> metaPars = new HashMap();
    public final JacType system;
    public final Settings settings;
    public GuiMode mode = GuiMode.VOID;
    private DataStore dataStore;
    private DateTime cursor = DateTime.now();
    private Interval scope = new Interval(Duration.standardDays(1L), (ReadableInstant)this.cursor);
    public Header cursorHeader;
    public final boolean noTimeServer;
    private LinkedHashSet<String> activePars = new LinkedHashSet();
    private ExecutorService doAsyncWorkers = Executors.newFixedThreadPool(3, new NamedThreadFactory("doAsync Worker", 1));
    private JacPublicDefinitions.UserLevel userLevel = JacPublicDefinitions.UserLevel.USER;
    private JacPublicDefinitions.UserLevel lastUserLevel = JacPublicDefinitions.UserLevel.USER;
    public TransferHandler dropFallback;
    private JFrame rootFrame = null;

    public AppState(JacType system, boolean noTimeServer) {
        super("Base");
        this.system = system;
        this.settings = new Settings(system);
        this.noTimeServer = noTimeServer;
    }

    public Interval getScope() {
        return this.scope;
    }

    private ModifiableHeader getHeader(DateTime newCursor) {
        ModifiableHeader newHeader;
        try {
            newHeader = ModifiableHeader.from(this.dataStore.getHeaderAt(newCursor));
        }
        catch (IllegalStateException ignore) {
            newHeader = ModifiableHeader.from(this.cursorHeader);
            newHeader.descriptors.clear();
        }
        return newHeader;
    }

    public void setScope(Interval scope) {
        if (!scope.contains(this.cursor)) {
            this.setTracking(false);
        }
        this.scope = scope;
        this.updates.post(scope);
    }

    public DateTime getCursor() {
        return this.cursor;
    }

    public void setCursor(DateTime cursor) {
        try {
            ModifiableHeader newHeader = this.getHeader(cursor);
            for (MetaPar metaPar : metaPars.values()) {
                newHeader.descriptors.put(metaPar.descriptor.id, metaPar.descriptor);
            }
            if (!newHeader.equals(this.cursorHeader)) {
                this.cursorHeader = newHeader;
                this.updates.post(newHeader);
                this.updates.post(new Trigger("panelRebuild"));
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.cursor = cursor;
        this.updates.post(cursor);
    }

    public void setScope(Duration duration) {
        DateTime center = this.scope.contains(this.cursor) ? this.cursor : this.scope.getStart().plus(this.scope.toDuration().dividedBy(2L));
        this.setScope(new Interval((ReadableInstant)center.minus(duration.dividedBy(2L)), (ReadableInstant)center.plus(duration.dividedBy(2L))));
    }

    public void setScopeOnCursor(double phase) {
        this.setScopeOnCursor(phase, this.scope.toDuration());
    }

    public void setScopeOnCursor(double phase, Duration duration) {
        DateTime cursor = this.cursor.plus(Duration.standardSeconds(2L));
        this.setScope(new Interval((ReadableInstant)cursor.minus((long)((double)duration.getMillis() * phase)), (ReadableInstant)cursor.plus((long)((double)duration.getMillis() * (1.0 - phase)))));
    }

    public Descriptor getDescriptor(String parId) {
        return this.cursorHeader.descriptors.get(parId);
    }

    public ImmutableSet<String> getPerLoggedPars(HwClock at) {
        return this.dataStore.getPerLoggedPars(at);
    }

    public Descriptor getYoungestDescriptor(String parId) {
        Header header = this.dataStore.timeMap.logs.getLast().getValue().header;
        if (header == null) {
            header = this.dataStore.getHeaderAt(this.getTimeLineEnd());
        }
        return header.descriptors.get(parId);
    }

    public DateTimeZone getConfiguredTimeZone() {
        switch (this.settings.timeZoneSource.get()) {
            case FROM_JAC: {
                return this.dataStore.timeLine.getSourceTimeZone();
            }
            case LOCAL: {
                return DateTimeZone.getDefault();
            }
        }
        return DateTimeZone.UTC;
    }

    public DateTimeFormatter zonedDateTimeFormat() {
        return SGUtils.DATE_TIME_FORMATTER.withLocale(SGUtils.getLocale()).withZone(this.getConfiguredTimeZone());
    }

    public void setScopeFull() {
        Range<DateTime> span = this.dataStore.timeLine.getUncoveredSet().complement().span();
        long padding = new Duration(span.lowerEndpoint(), span.upperEndpoint()).getMillis() / 10L;
        this.setScope(TimeLine.m(TimeLine.pad(span, padding)));
    }

    void bindDataStore(DataStore dataStore, boolean isInteractive) {
        this.bindDataStore(dataStore, isInteractive, true);
    }

    void bindDataStore(DataStore dataStore, boolean isInteractive, boolean destroyOldSource) {
        if (this.dataStore != null) {
            this.dataStore.unregisterEvents(this.updates);
            this.dataStore.terminateExecutors();
            if (destroyOldSource) {
                this.dataStore.getSource().destroy();
            }
        }
        this.dataStore = dataStore;
        this.updates.register(dataStore);
        this.updates.register(dataStore.queueProducer);
        this.updates.register(dataStore.queueConsumer);
        this.setCursor(this.getTimeLineEnd());
        if (isInteractive) {
            this.setTracking(true);
        } else {
            this.mode = GuiMode.STANDALONE;
            this.updates.post((Object)this.mode);
            LocalAuth.setChallengeFromHash(dataStore.getSource().hashCode());
            this.setScopeFull();
        }
    }

    public String sampleLabel(String parId, Sample s, long millis) {
        if (s.isVoid()) {
            return "<void>";
        }
        if (s.isAbsent()) {
            return "-";
        }
        Descriptor d = null;
        if (this.dataStore.timeLine.getUncoveredSet().contains(new DateTime(millis))) {
            return "-";
        }
        try {
            Header header = this.dataStore.getHeaderAt(new DateTime(millis));
            if (header == null) {
                return "?";
            }
            d = header.descriptors.get(parId);
        }
        catch (IllegalStateException ignore) {
            // empty catch block
        }
        if (d == null) {
            return "";
        }
        if (s.isUncached()) {
            return "\u2026";
        }
        return d.getLabel(s);
    }

    public String sampleLabel(String parId, long time) {
        return this.sampleLabel(parId, this.cachedSample(parId, time), time);
    }

    public Sample cachedSample(String parId, long millis) {
        return this.dataStore.fromCache(parId, millis);
    }

    public RangeSet<HwClock> getFileCoverage() {
        return this.dataStore.timeLine.getFileCoverage();
    }

    public ArrayList<Sample> cachedSamples(String parId, Interval interval, int count) {
        if (metaPars.containsKey(parId)) {
            return metaPars.get(parId).getSamples(interval, count);
        }
        return this.dataStore.fromCache(parId, interval, count);
    }

    @Deprecated
    public boolean isStandalone() {
        return !this.mode.isInteractive;
    }

    public DateTime getTimeLineEnd() {
        return this.dataStore.timeLine.getEdge();
    }

    public TimeMap.MultiAxis<String> getErrors() {
        return this.dataStore.timeMap.errorMessages;
    }

    public <T extends Tab> void setActivePanel(Class<T> clazz) {
        this.updates.post(clazz);
    }

    public Future doAsync(Runnable task) {
        return this.doAsyncWorkers.submit(task);
    }

    public TreeRangeMap<DateTime, CacheVisualizer.DataState> getCacheState() {
        return this.dataStore.cacheVisualizer.getCacheState();
    }

    public void setParVisibility(String par, boolean visible) {
        if (visible) {
            this.activePars.add(par);
        } else {
            this.dataStore.queueProducer.removeMiss(par);
            this.activePars.remove(par);
        }
        this.updates.post(new Trigger("timeLineRepaint"));
    }

    public void prepareData(long millis, Collection<String> pars) {
        this.dataStore.prepareData(millis, pars);
    }

    public void putMetaPar(MetaPar par) {
        metaPars.put(par.descriptor.id, par);
    }

    public void setTracking(boolean tracking) {
        switch (this.mode) {
            case TRACKING: {
                if (tracking) {
                    return;
                }
                this.mode = GuiMode.LIVE;
                break;
            }
            case VOID: 
            case LIVE: {
                if (!tracking) {
                    return;
                }
                this.mode = GuiMode.TRACKING;
                this.setCursor(this.getTimeLineEnd());
                if (this.scope.contains(this.cursor)) break;
                this.setScopeOnCursor(0.9);
            }
        }
        this.updates.post((Object)this.mode);
    }

    public void setConnected(boolean connected) {
        switch (this.mode) {
            case TRACKING: {
                if (connected) {
                    return;
                }
                this.mode = GuiMode.TRACKING_DISCONNECTED;
                break;
            }
            case LIVE: {
                if (connected) {
                    return;
                }
                this.mode = GuiMode.LIVE_DISCONNECTED;
                break;
            }
            case VOID: 
            case LIVE_DISCONNECTED: {
                if (!connected) {
                    return;
                }
                this.mode = GuiMode.LIVE;
                break;
            }
            case TRACKING_DISCONNECTED: {
                if (!connected) {
                    return;
                }
                this.setCursor(new DateTime());
                this.setScopeOnCursor(0.8);
                this.mode = GuiMode.TRACKING;
            }
        }
        this.updates.post((Object)this.mode);
    }

    public boolean isMode(GuiMode mode) {
        return this.mode.equals((Object)mode);
    }

    public HwClock millisToHwClock(long time) {
        return this.dataStore.timeLine.toHwClock(time);
    }

    public DateTime hwClockToMillis(HwClock clock) {
        return this.dataStore.timeLine.toDateTime(clock);
    }

    public void bumpTimeLineEnd(HwClock edgeTs) {
        this.dataStore.timeLine.bumpEdge(edgeTs);
        if (this.cursor.isAfter(this.getTimeLineEnd())) {
            this.setCursor(this.getTimeLineEnd());
        }
    }

    public Set<String> getActivePars() {
        return this.activePars;
    }

    public void setUserLevel(JacPublicDefinitions.UserLevel userLevel) {
        this.userLevel = userLevel;
        this.updates.post((Object)userLevel);
    }

    public JacPublicDefinitions.UserLevel getUserLevel() {
        return this.userLevel;
    }

    public void setLastUserLevel() {
        this.lastUserLevel = this.userLevel;
    }

    public JacPublicDefinitions.UserLevel getLastUserLevel() {
        return this.lastUserLevel;
    }

    public void clearLastUserLevel() {
        this.lastUserLevel = JacPublicDefinitions.UserLevel.USER;
    }

    public void showSaveDialog() {
        new SaveDialog(this, this.dataStore, this.dataStore.getJac());
    }

    public void showExportDialog() {
        new ExportCsv(this, this.dataStore, this.dataStore.getJac());
    }

    public void wrapTransferHandler(JComponent component) {
        component.setTransferHandler(new TransferHandlerProxy(component.getTransferHandler(), this.dropFallback));
    }

    public TimeLine getTimeLine() {
        return this.dataStore.timeLine;
    }

    public RangeMap<DateTime, TimeLine.CoverageState> getCoverage() {
        return this.dataStore.timeLine.getCoverage();
    }

    public JFrame getRootFrame() {
        return this.rootFrame;
    }

    public void bindRootFrame(JacServiceGui jacServiceGui) {
        this.rootFrame = jacServiceGui;
    }

    public boolean timeTileLoadOk() {
        return this.dataStore.timeTileLoadOk();
    }
}

