/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.jac.server.soap;

import ch.bruker.util.BUtil;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.ws.WebFault;

public class JacSoapCommon {

    public static class JacIoErrorFaultInfo {
        public int statementId;
        public String statement;

        public JacIoErrorFaultInfo() {
        }

        public JacIoErrorFaultInfo(int statementId, String statement) {
            this.statementId = statementId;
            this.statement = statement;
        }
    }

    @WebFault
    public static class JacIoError
    extends Exception {
        private JacIoErrorFaultInfo faultInfo;

        public JacIoError(String message, JacIoErrorFaultInfo faultInfo) {
            super(message);
            this.faultInfo = faultInfo;
        }

        public JacIoError(int statementId, String statement) {
            super(statement);
            this.faultInfo = new JacIoErrorFaultInfo(statementId, statement);
        }

        public JacIoErrorFaultInfo getFaultInfo() {
            return this.faultInfo;
        }
    }

    public static class JacProperty {
        public String parId;
        public JacValueType value;

        public JacProperty() {
        }

        public JacProperty(String parId, JacValueType value) {
            this.parId = parId;
            this.value = value;
        }
    }

    public static final class JacValueType {
        @XmlAttribute
        public JacValueTypes type;
        @XmlAttribute
        public String value;

        public JacValueTypes discriminator() {
            return this.type;
        }

        public void Int32Val(int value) {
            this.type = JacValueTypes.INT32;
            this.value = Integer.toString(value);
        }

        public int Int32Val() {
            return Integer.parseInt(this.value);
        }

        public void FloatVal(float value) {
            this.type = JacValueTypes.FLOAT;
            this.value = Float.toString(value);
        }

        public float FloatVal() {
            return Float.parseFloat(this.value);
        }

        public void DoubleVal(double value) {
            this.type = JacValueTypes.DOUBLE;
            this.value = Double.toString(value);
        }

        public double DoubleVal() {
            return Double.parseDouble(this.value);
        }

        public void StringVal(String value) {
            this.type = JacValueTypes.STRING;
            this.value = value;
        }

        public String StringVal() {
            return this.value;
        }

        public void BooleanVal(boolean value) {
            this.type = JacValueTypes.BOOLEAN;
            this.value = Boolean.toString(value);
        }

        public boolean BooleanVal() {
            return Boolean.parseBoolean(this.value);
        }

        public void ByteArrayVal(byte[] value) {
            this.type = JacValueTypes.BYTE_ARRAY;
            this.value = BUtil.binaryDataToBase64String(value, value.length);
        }

        public byte[] ByteArrayVal() {
            return BUtil.base64StringToBinaryData(this.value);
        }

        public void EmptyValue(boolean value) {
            this.type = JacValueTypes.EMPTY;
            this.value = Boolean.toString(value);
        }

        public boolean EmptyValue() {
            return Boolean.parseBoolean(this.value);
        }
    }

    public static enum JacValueTypes {
        EMPTY,
        INT32,
        FLOAT,
        DOUBLE,
        STRING,
        BOOLEAN,
        BYTE_ARRAY;

    }
}

