/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.jac.config;

import ch.bruker.jac.config.JacPublicDefinitions;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public final class LocalAuth {
    public static final int MAX_CHALLENGE_NR = 99999;
    private static int challenge = -1;
    public static final int LEVEL_TH = 500000;

    private static int calculateChallengeResponseNrRad(JacPublicDefinitions.UserLevel level, int challengeNumber) {
        switch (level) {
            case SERVICE: {
                return (int)((1.0 + Math.sin(Math.sqrt(11.0) * (double)challengeNumber)) * 249999.0);
            }
            case DEVELOPER: {
                return (int)((3.0 + Math.sin(Math.sqrt(33.0) * (double)challengeNumber)) * 250001.0);
            }
        }
        return 0;
    }

    public static void main(String[] args) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        while (true) {
            System.out.println("Enter Challenge Number");
            String s = br.readLine();
            int challengeNr = Integer.parseInt(s);
            System.out.println("Service Response Number: " + LocalAuth.calculateChallengeResponseNrDeg(JacPublicDefinitions.UserLevel.SERVICE, challengeNr));
            System.out.println("Developer Response Number: " + LocalAuth.calculateChallengeResponseNrDeg(JacPublicDefinitions.UserLevel.DEVELOPER, challengeNr));
        }
    }

    private static int calculateChallengeResponseNrDeg(JacPublicDefinitions.UserLevel level, int challengeNumber) {
        switch (level) {
            case SERVICE: {
                return (int)((1.0 + Math.sin(Math.sqrt(11.0) * 3.14159265359 / 180.0 * (double)challengeNumber)) * 249999.0);
            }
            case DEVELOPER: {
                return (int)((3.0 + Math.sin(Math.sqrt(33.0) * 3.14159265359 / 180.0 * (double)challengeNumber)) * 250001.0);
            }
        }
        return 0;
    }

    public static JacPublicDefinitions.UserLevel verify(String pw) {
        int password = 0;
        try {
            password = Integer.parseInt(pw);
        }
        catch (Exception e) {
            return JacPublicDefinitions.UserLevel.USER;
        }
        if (password > 500000) {
            int i = LocalAuth.calculateChallengeResponseNrRad(JacPublicDefinitions.UserLevel.DEVELOPER, challenge);
            if (i <= password + 1 && i >= password - 1) {
                return JacPublicDefinitions.UserLevel.DEVELOPER;
            }
            i = LocalAuth.calculateChallengeResponseNrDeg(JacPublicDefinitions.UserLevel.DEVELOPER, challenge);
            if (i <= password + 1 && i >= password - 1) {
                return JacPublicDefinitions.UserLevel.DEVELOPER;
            }
        } else {
            int i = LocalAuth.calculateChallengeResponseNrRad(JacPublicDefinitions.UserLevel.SERVICE, challenge);
            if (i <= password + 1 && i >= password - 1) {
                return JacPublicDefinitions.UserLevel.SERVICE;
            }
            i = LocalAuth.calculateChallengeResponseNrDeg(JacPublicDefinitions.UserLevel.SERVICE, challenge);
            if (i <= password + 1 && i >= password - 1) {
                return JacPublicDefinitions.UserLevel.SERVICE;
            }
        }
        return JacPublicDefinitions.UserLevel.USER;
    }

    public static int getChallenge() {
        if (challenge < 0) {
            challenge = (int)(99999.0 * Math.random());
        }
        return challenge;
    }

    public static void setChallengeFromHash(int hashCode) {
        challenge = Math.abs(hashCode) % 99999;
    }
}

